/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectionUtils {
    private static final Logger log = LoggerFactory.getLogger(ReflectionUtils.class);
    private static final String TYPE_WITH_SINGLE_GENERIC_TYPE_REGEXP = "[a-zA-Z0-9_.]*<[a-zA-Z0-9_.]*>";
    private static final Pattern SINGLE_GENERIC_TYPE_REGEXP = Pattern.compile("<([a-zA-Z0-9_.]*)>");
    private static final String FAILED_MSG_PATTERN = "Failed to instantiate class: '%s'";

    public static Object extractSingeGenericType(String typeName) {
        if (!typeName.matches(TYPE_WITH_SINGLE_GENERIC_TYPE_REGEXP)) {
            throw new DtoGeneratorException("Next type must have single generic type: '" + typeName + "'");
        }
        Matcher matcher = SINGLE_GENERIC_TYPE_REGEXP.matcher(typeName);
        if (!matcher.find()) {
            throw new DtoGeneratorException("Cannot find generic type using next regex pattern: " + SINGLE_GENERIC_TYPE_REGEXP.pattern() + " in type: '" + typeName + "'");
        }
        return ReflectionUtils.getClass(matcher.group(1), typeName);
    }

    public static Class<?> getSingleGenericType(Field field) throws DtoGeneratorException {
        return (Class)ReflectionUtils.extractSingeGenericType(field.getGenericType().getTypeName());
    }

    private static Class<?> getClass(String className, String typeName) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new DtoGeneratorException("Can't create class for name: '" + className + "' obtained from type: '" + typeName + "'", e);
        }
    }

    public static <T> T createInstance(Class<T> dtoClass) {
        try {
            Constructor<?>[] declaredConstructors = dtoClass.getDeclaredConstructors();
            Optional<Constructor> maybeNoArgsConstructor = Arrays.stream(declaredConstructors).filter(constructor -> constructor.getParameterCount() == 0).findAny();
            if (!maybeNoArgsConstructor.isPresent()) {
                throw new DtoGeneratorException(String.format(FAILED_MSG_PATTERN, dtoClass) + " Class must have no-args constructor.");
            }
            Constructor constructor2 = maybeNoArgsConstructor.get();
            constructor2.setAccessible(true);
            return constructor2.newInstance(new Object[0]);
        }
        catch (InstantiationException ie) {
            throw new DtoGeneratorException(String.format(FAILED_MSG_PATTERN, dtoClass) + " Maybe no-args constructor was not found.", ie);
        }
        catch (Exception e) {
            throw new DtoGeneratorException(String.format(FAILED_MSG_PATTERN, dtoClass), e);
        }
    }

    public static <T> T createCollectionInstance(Class<T> collectionClass) {
        T collectionInstance;
        if (collectionClass.isInterface() || Modifier.isAbstract(collectionClass.getModifiers())) {
            throw new DtoGeneratorException("Can't create instance of '" + collectionClass + "' because it is interface or abstract.");
        }
        try {
            collectionInstance = collectionClass.newInstance();
        }
        catch (Exception e) {
            log.error("Exception while creating Collection instance ", (Throwable)e);
            throw new DtoGeneratorException(e);
        }
        return collectionInstance;
    }

    public static void assertTypeCompatibility(Class<?> fieldType, Class<?> collectionClass) {
        if (!fieldType.isAssignableFrom(collectionClass)) {
            throw new DtoGeneratorException("CollectionClass from rules: '" + collectionClass + "' can't be assign to the field: " + fieldType);
        }
    }

    public static <T> T getDefaultMethodValue(Class<? extends Annotation> annotationClass, String methodName, Class<T> valueType) throws NoSuchMethodException {
        Method declaredMethod = annotationClass.getDeclaredMethod(methodName, new Class[0]);
        Object defaultValue = declaredMethod.getDefaultValue();
        if (defaultValue.getClass() == valueType) {
            return (T)defaultValue;
        }
        throw new ClassCastException("Field");
    }

    private ReflectionUtils() {
    }
}

