package org.laoruga.dtogenerator.api.generators.custom;

import java.util.function.Supplier;

/**
 * Custom generators based on this interface are able to have a reference to DTO instance,
 * which makes it possible to use data from DTO instance in custom generator logic.
 * <p>
 * Implementation of method {@link CustomGeneratorDtoDependent#isDtoReady()} have to check
 * if required to this generator DTO fields have been already generated by other generators.
 * Generator executes when this method returns 'true', otherwise execution will be delayed until all others
 * generators will have been executed. Because the order of generators execution is not guaranteed.
 * <p>
 * Configuration parameter 'maxFailuresNumberDuringDtoGeneration', among other causes of failures,
 * is used to define max number of 'false' results returned by {@link CustomGeneratorDtoDependent#isDtoReady()}.
 *
 * @author Il'dar Valitov
 * Created on 16.04.2022
 */

public interface CustomGeneratorDtoDependent<T, V> extends CustomGenerator<T> {

    /**
     * Injects DTO instance supplier.
     *
     * @param generatedDto generated DTO instance supplier
     */
    void setDtoSupplier(Supplier<V> generatedDto);

    /**
     * Custom generator executes as soon as this method returns true.
     * <p>
     * Because of the order of generators execution is not guaranteed,
     * this method have to check if all the required fields have already been generated.
     *
     * @return true - if the DTO instance already has values of all required fields,
     * false - otherwise
     */
    boolean isDtoReady();
}
