/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.laoruga.dtogenerator.api.generators.custom.CustomGenerator;
import org.laoruga.dtogenerator.util.dummy.DummyCustomGenerator;

public class CustomGeneratorsConfigMapHolder {
    private final Map<String, Map<String, String>> configMapsByField = new HashMap<String, Map<String, String>>();
    private final Map<Class<? extends CustomGenerator<?>>, Map<String, String>> configMapsByGenerator;

    public CustomGeneratorsConfigMapHolder() {
        this(new ConcurrentHashMap());
    }

    CustomGeneratorsConfigMapHolder(CustomGeneratorsConfigMapHolder toCopy) {
        this(toCopy.configMapsByGenerator.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new ConcurrentHashMap((Map)entry.getValue()))));
    }

    private CustomGeneratorsConfigMapHolder(Map<Class<? extends CustomGenerator<?>>, Map<String, String>> customRuleRemarksMapByGenerator) {
        this.configMapsByGenerator = customRuleRemarksMapByGenerator;
    }

    void addParameterForField(@NonNull String filedName, @NonNull String remarkName, @NonNull String remarkValue) {
        if (filedName == null) {
            throw new NullPointerException("filedName is marked non-null but is null");
        }
        if (remarkName == null) {
            throw new NullPointerException("remarkName is marked non-null but is null");
        }
        if (remarkValue == null) {
            throw new NullPointerException("remarkValue is marked non-null but is null");
        }
        this.configMapsByField.putIfAbsent(filedName, new HashMap());
        this.configMapsByField.get(filedName).put(remarkName, remarkValue);
    }

    void addParameterForGeneratorType(@NonNull Class<? extends CustomGenerator<?>> generatorClass, @NonNull String key, @NonNull String value) {
        if (generatorClass == null) {
            throw new NullPointerException("generatorClass is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.configMapsByGenerator.putIfAbsent(generatorClass, new HashMap());
        this.configMapsByGenerator.get(generatorClass).put(key, value);
    }

    public Map<String, String> fillConfigMap(String fieldName, Class<?> generatorClass, Map<String, String> configMap) {
        this.getConfigMap(DummyCustomGenerator.class).ifPresent(configMap::putAll);
        this.getConfigMap(generatorClass).ifPresent(configMap::putAll);
        this.getConfigMap(fieldName).ifPresent(configMap::putAll);
        return configMap;
    }

    private Optional<Map<String, String>> getConfigMap(Class<?> customGeneratorClass) {
        return Optional.ofNullable(this.configMapsByGenerator.get(customGeneratorClass));
    }

    private Optional<Map<String, String>> getConfigMap(String fieldName) {
        return Optional.ofNullable(this.configMapsByField.get(fieldName));
    }
}

