/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator;

import java.util.function.Supplier;
import org.laoruga.dtogenerator.DtoGeneratorBuilder;
import org.laoruga.dtogenerator.DtoInstanceSupplier;
import org.laoruga.dtogenerator.ErrorsHolder;
import org.laoruga.dtogenerator.FieldGenerators;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.generator.executors.BatchExecutor;
import org.laoruga.dtogenerator.generator.executors.ExecutorOfCollectionGenerator;
import org.laoruga.dtogenerator.generator.executors.ExecutorOfDtoDependentGenerator;
import org.laoruga.dtogenerator.generator.executors.ExecutorOfGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtoGenerator<T> {
    private static final Logger log = LoggerFactory.getLogger(DtoGenerator.class);
    private final ErrorsHolder errorsHolder = new ErrorsHolder();
    private BatchExecutor batchExecutor;
    private final Supplier<?> dtoInstanceSupplier;
    private final FieldGenerators fieldGenerators;

    public DtoGenerator(FieldGenerators fieldGenerators, Supplier<?> dtoInstanceSupplier) {
        this.fieldGenerators = fieldGenerators;
        this.dtoInstanceSupplier = dtoInstanceSupplier;
    }

    public static <T> DtoGeneratorBuilder<T> builder(Class<T> dtoClass) {
        return new DtoGeneratorBuilder<Class<T>>(dtoClass);
    }

    public static <T> DtoGeneratorBuilder<T> builder(T dtoInstance) {
        return new DtoGeneratorBuilder<T>(dtoInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T generateDto() {
        Object dtoInstance;
        try {
            if (this.dtoInstanceSupplier instanceof DtoInstanceSupplier) {
                ((DtoInstanceSupplier)this.dtoInstanceSupplier).updateInstance();
            }
            dtoInstance = this.dtoInstanceSupplier.get();
            DtoGenerator dtoGenerator = this;
            synchronized (dtoGenerator) {
                if (this.batchExecutor == null) {
                    ExecutorOfGenerator generalGeneratorExecutor = new ExecutorOfGenerator();
                    ExecutorOfCollectionGenerator collectionGeneratorExecutor = new ExecutorOfCollectionGenerator(generalGeneratorExecutor);
                    ExecutorOfDtoDependentGenerator dtoDependentGeneratorExecutor = new ExecutorOfDtoDependentGenerator(collectionGeneratorExecutor);
                    this.batchExecutor = new BatchExecutor(dtoDependentGeneratorExecutor, this.fieldGenerators);
                }
            }
            this.batchExecutor.execute();
        }
        catch (Exception e) {
            throw new DtoGeneratorException("Error during generators execution", e);
        }
        finally {
            if (this.dtoInstanceSupplier instanceof DtoInstanceSupplier) {
                ((DtoInstanceSupplier)this.dtoInstanceSupplier).remove();
            }
        }
        return (T)dtoInstance;
    }

    ErrorsHolder getErrorsHolder() {
        return this.errorsHolder;
    }
}

