/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator;

import java.util.Arrays;
import java.util.function.Supplier;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.laoruga.dtogenerator.CustomGeneratorsConfigMapHolder;
import org.laoruga.dtogenerator.DtoGenerator;
import org.laoruga.dtogenerator.DtoGeneratorBuildersTree;
import org.laoruga.dtogenerator.DtoInstanceSupplier;
import org.laoruga.dtogenerator.FieldFilter;
import org.laoruga.dtogenerator.FieldGeneratorsPreparer;
import org.laoruga.dtogenerator.FieldGeneratorsProvider;
import org.laoruga.dtogenerator.RemarksHolder;
import org.laoruga.dtogenerator.api.generators.Generator;
import org.laoruga.dtogenerator.api.generators.custom.CustomGeneratorArgs;
import org.laoruga.dtogenerator.api.generators.custom.CustomGeneratorConfigMap;
import org.laoruga.dtogenerator.config.Configuration;
import org.laoruga.dtogenerator.config.ConfigurationHolder;
import org.laoruga.dtogenerator.config.CustomGeneratorsConfigurationHolder;
import org.laoruga.dtogenerator.config.TypeGeneratorsConfigForFiled;
import org.laoruga.dtogenerator.config.dto.DtoGeneratorInstanceConfig;
import org.laoruga.dtogenerator.config.dto.DtoGeneratorStaticConfig;
import org.laoruga.dtogenerator.config.types.TypeGeneratorsConfigLazy;
import org.laoruga.dtogenerator.constants.Boundary;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.generator.config.dto.ConfigDto;
import org.laoruga.dtogenerator.util.StringUtils;
import org.laoruga.dtogenerator.util.dummy.DummyCustomGenerator;

public class DtoGeneratorBuilder<T> {
    private final ConfigurationHolder configuration;
    private final FieldGeneratorsProvider fieldGeneratorsProvider;
    private final DtoGeneratorBuildersTree dtoGeneratorBuildersTree;
    private final RemarksHolder remarksHolder;
    private final CustomGeneratorsConfigMapHolder customGeneratorsConfigMapHolder;
    private final Class<?> dtoType;
    private final Supplier<?> dtoInstanceSupplier;

    DtoGeneratorBuilder(Class<T> dtoClass) {
        this(new DtoInstanceSupplier(dtoClass), dtoClass);
    }

    DtoGeneratorBuilder(T dtoInstance) {
        this(() -> dtoInstance, dtoInstance.getClass());
    }

    private DtoGeneratorBuilder(Supplier<?> dtoInstanceSupplier, Class<?> dtoType) {
        this.dtoInstanceSupplier = dtoInstanceSupplier;
        this.dtoType = dtoType;
        this.remarksHolder = new RemarksHolder();
        this.customGeneratorsConfigMapHolder = new CustomGeneratorsConfigMapHolder();
        ConfigurationHolder configurationHolder = new ConfigurationHolder(new DtoGeneratorInstanceConfig(), new TypeGeneratorsConfigLazy(), new TypeGeneratorsConfigForFiled(), new CustomGeneratorsConfigurationHolder(dtoInstanceSupplier, this.remarksHolder, this.customGeneratorsConfigMapHolder));
        this.fieldGeneratorsProvider = new FieldGeneratorsProvider(configurationHolder, this.remarksHolder, this.customGeneratorsConfigMapHolder, new FieldFilter(), new String[]{"%ROOT%"}, this::getDtoGeneratorBuildersTree, dtoInstanceSupplier);
        this.configuration = configurationHolder;
        this.dtoGeneratorBuildersTree = new DtoGeneratorBuildersTree(this);
    }

    protected DtoGeneratorBuilder(DtoGeneratorBuilder<?> copyFrom, String[] pathFromRootDto, Supplier<?> dtoInstanceSupplier, Class<?> dtoType) {
        ConfigurationHolder configurationCopy;
        this.dtoInstanceSupplier = dtoInstanceSupplier;
        this.dtoType = dtoType;
        this.dtoGeneratorBuildersTree = copyFrom.getDtoGeneratorBuildersTree();
        this.customGeneratorsConfigMapHolder = new CustomGeneratorsConfigMapHolder(copyFrom.getCustomGeneratorsConfigMapHolder());
        this.remarksHolder = new RemarksHolder(copyFrom.getRemarksHolder());
        Supplier<?> rootDtoInstanceSupplier = this.dtoGeneratorBuildersTree.getBuilderLazy("%ROOT%").getFieldGeneratorsProvider().getDtoInstanceSupplier();
        this.configuration = configurationCopy = new ConfigurationHolder(copyFrom.getConfiguration().getDtoGeneratorConfig(), copyFrom.getConfiguration().getTypeGeneratorsConfig(), new CustomGeneratorsConfigurationHolder(rootDtoInstanceSupplier, this.remarksHolder, this.customGeneratorsConfigMapHolder, copyFrom.getConfiguration().getCustomGeneratorsConfigurators().getByGeneratorType()));
        this.fieldGeneratorsProvider = new FieldGeneratorsProvider(copyFrom.getFieldGeneratorsProvider(), this.remarksHolder, this.customGeneratorsConfigMapHolder, pathFromRootDto, dtoInstanceSupplier, configurationCopy);
    }

    public DtoGenerator<T> build() {
        FieldGeneratorsPreparer fieldGeneratorsPreparer = new FieldGeneratorsPreparer();
        fieldGeneratorsPreparer.prepareGenerators(this.dtoType, this.fieldGeneratorsProvider);
        return new DtoGenerator(fieldGeneratorsPreparer.getFiledGenerators(), this.dtoInstanceSupplier);
    }

    public <U> DtoGeneratorBuilder<T> setGenerator(@NonNull Class<U> generatedType, @NonNull Generator<? extends U> typeGenerator) {
        if (generatedType == null) {
            throw new NullPointerException("generatedType is marked non-null but is null");
        }
        if (typeGenerator == null) {
            throw new NullPointerException("typeGenerator is marked non-null but is null");
        }
        this.fieldGeneratorsProvider.setGenerator(generatedType, typeGenerator);
        return this;
    }

    public DtoGeneratorBuilder<T> setGenerator(@NonNull String fieldName, @NonNull Generator<?> typeGenerator) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (typeGenerator == null) {
            throw new NullPointerException("typeGenerator is marked non-null but is null");
        }
        Pair<String, String[]> fieldNameAndPath = StringUtils.splitPath(fieldName);
        this.dtoGeneratorBuildersTree.getBuilderLazy((String[])fieldNameAndPath.getRight()).getFieldGeneratorsProvider().setGeneratorForField((String)fieldNameAndPath.getLeft(), typeGenerator);
        return this;
    }

    public <U> DtoGeneratorBuilder<T> setGenerator(@NonNull Class<U> generatedType, @NonNull CustomGeneratorArgs<? extends U> typeGenerator, String ... args) {
        if (generatedType == null) {
            throw new NullPointerException("generatedType is marked non-null but is null");
        }
        if (typeGenerator == null) {
            throw new NullPointerException("typeGenerator is marked non-null but is null");
        }
        this.setGenerator(generatedType, typeGenerator);
        this.setGeneratorArgs(typeGenerator.getClass(), args);
        return this;
    }

    public DtoGeneratorBuilder<T> setGenerator(@NonNull String fieldName, @NonNull CustomGeneratorArgs<?> typeGenerator, String ... args) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (typeGenerator == null) {
            throw new NullPointerException("typeGenerator is marked non-null but is null");
        }
        this.setGenerator(fieldName, typeGenerator);
        this.setGeneratorArgs(fieldName, args);
        return this;
    }

    public <U> DtoGeneratorBuilder<T> setGeneratorConfig(@NonNull Class<U> generatedType, @NonNull ConfigDto configDto) {
        if (generatedType == null) {
            throw new NullPointerException("generatedType is marked non-null but is null");
        }
        if (configDto == null) {
            throw new NullPointerException("configDto is marked non-null but is null");
        }
        this.fieldGeneratorsProvider.setGeneratorConfigForType(generatedType, configDto);
        return this;
    }

    public DtoGeneratorBuilder<T> setGeneratorConfig(@NonNull String fieldName, @NonNull ConfigDto generatorConfig) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (generatorConfig == null) {
            throw new NullPointerException("generatorConfig is marked non-null but is null");
        }
        Pair<String, String[]> fieldNameAndPath = StringUtils.splitPath(fieldName);
        this.dtoGeneratorBuildersTree.getBuilderLazy((String[])fieldNameAndPath.getRight()).getFieldGeneratorsProvider().setGeneratorConfigForField((String)fieldNameAndPath.getLeft(), generatorConfig);
        return this;
    }

    public DtoGeneratorBuilder<T> setBoundary(@NonNull Boundary boundary) throws DtoGeneratorException {
        if (boundary == null) {
            throw new NullPointerException("boundary is marked non-null but is null");
        }
        this.remarksHolder.setRuleRemarkForAnyField(boundary);
        return this;
    }

    public DtoGeneratorBuilder<T> setBoundary(@NonNull String fieldName, @NonNull Boundary boundary) throws DtoGeneratorException {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (boundary == null) {
            throw new NullPointerException("boundary is marked non-null but is null");
        }
        Pair<String, String[]> fieldNameAndPath = StringUtils.splitPath(fieldName);
        this.dtoGeneratorBuildersTree.getBuilderLazy((String[])fieldNameAndPath.getRight()).getRemarksHolder().setRuleRemarkForField((String)fieldNameAndPath.getLeft(), boundary);
        return this;
    }

    public DtoGeneratorBuilder<T> setGeneratorArgs(@NonNull Class<? extends CustomGeneratorArgs<?>> customGeneratorClass, String ... args) {
        if (customGeneratorClass == null) {
            throw new NullPointerException("customGeneratorClass is marked non-null but is null");
        }
        this.configuration.getCustomGeneratorsConfigurators().setArgs(customGeneratorClass, args);
        return this;
    }

    public DtoGeneratorBuilder<T> setGeneratorArgs(String fieldName, String ... args) {
        Pair<String, String[]> fieldNameAndPath = StringUtils.splitPath(fieldName);
        this.dtoGeneratorBuildersTree.getBuilderLazy((String[])fieldNameAndPath.getRight()).getConfiguration().getCustomGeneratorsConfigurators().setArgs((String)fieldNameAndPath.getLeft(), args);
        return this;
    }

    public DtoGeneratorBuilder<T> addGeneratorParameter(@NonNull Class<? extends CustomGeneratorConfigMap<?>> customGeneratorClass, @NonNull String parameterName, @NonNull String parameterValue) {
        if (customGeneratorClass == null) {
            throw new NullPointerException("customGeneratorClass is marked non-null but is null");
        }
        if (parameterName == null) {
            throw new NullPointerException("parameterName is marked non-null but is null");
        }
        if (parameterValue == null) {
            throw new NullPointerException("parameterValue is marked non-null but is null");
        }
        this.customGeneratorsConfigMapHolder.addParameterForGeneratorType(customGeneratorClass, parameterName, parameterValue);
        return this;
    }

    public DtoGeneratorBuilder<T> addGeneratorParameters(@NonNull Class<? extends CustomGeneratorConfigMap<?>> customGeneratorClass, String ... parameterNameValuePairs) {
        if (customGeneratorClass == null) {
            throw new NullPointerException("customGeneratorClass is marked non-null but is null");
        }
        if (parameterNameValuePairs == null) {
            throw new NullPointerException("parameterNameValuePairs is marked non-null but is null");
        }
        if (parameterNameValuePairs.length % 2 > 0) {
            throw new IllegalArgumentException("Even parameters number expected (key-value pairs), but passed: " + Arrays.asList(parameterNameValuePairs));
        }
        for (int i = 0; i < parameterNameValuePairs.length; i += 2) {
            this.addGeneratorParameter(customGeneratorClass, parameterNameValuePairs[i], parameterNameValuePairs[i + 1]);
        }
        return this;
    }

    public DtoGeneratorBuilder<T> addGeneratorParameter(@NonNull String fieldName, @NonNull String parameterName, @NonNull String parameterValue) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (parameterName == null) {
            throw new NullPointerException("parameterName is marked non-null but is null");
        }
        if (parameterValue == null) {
            throw new NullPointerException("parameterValue is marked non-null but is null");
        }
        Pair<String, String[]> fieldNameAndPath = StringUtils.splitPath(fieldName);
        this.dtoGeneratorBuildersTree.getBuilderLazy((String[])fieldNameAndPath.getRight()).getCustomGeneratorsConfigMapHolder().addParameterForField((String)fieldNameAndPath.getLeft(), parameterName, parameterValue);
        return this;
    }

    public DtoGeneratorBuilder<T> addGeneratorParameter(@NonNull String parameterName, @NonNull String parameterValue) {
        if (parameterName == null) {
            throw new NullPointerException("parameterName is marked non-null but is null");
        }
        if (parameterValue == null) {
            throw new NullPointerException("parameterValue is marked non-null but is null");
        }
        this.addGeneratorParameter(DummyCustomGenerator.class, parameterName, parameterValue);
        return this;
    }

    public DtoGeneratorBuilder<T> addGeneratorParameters(@NonNull String fieldName, String ... nameValuePairs) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (nameValuePairs == null) {
            throw new NullPointerException("nameValuePairs is marked non-null but is null");
        }
        if (nameValuePairs.length % 2 > 0) {
            throw new IllegalArgumentException("Even parameters number expected (key-value pairs), but passed: " + Arrays.asList(nameValuePairs));
        }
        Pair<String, String[]> fieldNameAndPath = StringUtils.splitPath(fieldName);
        CustomGeneratorsConfigMapHolder customGeneratorsConfigMapHolder = this.dtoGeneratorBuildersTree.getBuilderLazy((String[])fieldNameAndPath.getRight()).getCustomGeneratorsConfigMapHolder();
        for (int i = 0; i < nameValuePairs.length; i += 2) {
            customGeneratorsConfigMapHolder.addParameterForField((String)fieldNameAndPath.getLeft(), nameValuePairs[i], nameValuePairs[i + 1]);
        }
        return this;
    }

    public DtoGeneratorBuilder<T> includeGroups(String ... groups) {
        if (groups != null && groups.length != 0) {
            this.fieldGeneratorsProvider.addGroups(groups);
        }
        return this;
    }

    public DtoGeneratorBuilder<T> ignoreField(String fieldName) {
        Pair<String, String[]> fieldNameAndPath = StringUtils.splitPath(fieldName);
        this.dtoGeneratorBuildersTree.getBuilderLazy((String[])fieldNameAndPath.getRight()).getFieldGeneratorsProvider().addFieldToIgnore((String)fieldNameAndPath.getLeft());
        return this;
    }

    public DtoGeneratorBuilder<T> ignoreFields(String ... fieldNames) {
        for (String fieldName : fieldNames) {
            this.ignoreField(fieldName);
        }
        return this;
    }

    public Configuration getConfig() {
        return this.configuration;
    }

    public Configuration getStaticConfig() {
        return DtoGeneratorStaticConfig.getInstance();
    }

    public DtoGeneratorBuilder<T> generateKnownTypes() {
        this.configuration.getDtoGeneratorConfig().setGenerateAllKnownTypes(true);
        return this;
    }

    protected ConfigurationHolder getConfiguration() {
        return this.configuration;
    }

    protected FieldGeneratorsProvider getFieldGeneratorsProvider() {
        return this.fieldGeneratorsProvider;
    }

    protected DtoGeneratorBuildersTree getDtoGeneratorBuildersTree() {
        return this.dtoGeneratorBuildersTree;
    }

    protected RemarksHolder getRemarksHolder() {
        return this.remarksHolder;
    }

    protected CustomGeneratorsConfigMapHolder getCustomGeneratorsConfigMapHolder() {
        return this.customGeneratorsConfigMapHolder;
    }
}

