/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.laoruga.dtogenerator.DtoGeneratorBuilder;
import org.laoruga.dtogenerator.DtoInstanceSupplier;
import org.laoruga.dtogenerator.FieldGeneratorsProvider;
import org.laoruga.dtogenerator.util.ReflectionUtils;

public class DtoGeneratorBuildersTree {
    public static final String ROOT = "%ROOT%";
    private final Node tree;

    public DtoGeneratorBuildersTree(DtoGeneratorBuilder<?> rootDtoGeneratorBuilder) {
        this.tree = new Node(rootDtoGeneratorBuilder, ROOT);
    }

    public DtoGeneratorBuilder<?> getBuilderLazy(String ... fields) {
        if (fields.length < 1) {
            throw new IllegalArgumentException("Path must contain at least 1 element, but was: " + Arrays.asList(fields));
        }
        return this.getBuilderLazy(fields, 0, this.tree).getDtoGeneratorBuilder();
    }

    public Node getNodeLazy(String ... fields) {
        if (fields.length < 1) {
            throw new IllegalArgumentException("Path must contain at least 1 element, but was: " + Arrays.asList(fields));
        }
        return this.getBuilderLazy(fields, 0, this.tree);
    }

    private Node getBuilderLazy(String[] fields, int idx, Node node) {
        if (fields.length - 1 == idx) {
            return node;
        }
        ++idx;
        for (Node child : node.getChildren()) {
            if (!Objects.equals(child.getFieldName(), fields[idx])) continue;
            return this.getBuilderLazy(fields, idx, child);
        }
        Node newNode = this.newNestedNode(fields, idx);
        node.getChildren().add(newNode);
        return newNode;
    }

    private Node newNestedNode(String[] fields, int idx) {
        Class<?> rootType = this.tree.dtoGeneratorBuilder.getFieldGeneratorsProvider().getDtoInstanceSupplier().get().getClass();
        Class<?> nestedDtoType = ReflectionUtils.getFieldType(fields, 1, rootType);
        DtoInstanceSupplier dtoInstanceSupplier = new DtoInstanceSupplier(nestedDtoType);
        return new Node(new DtoGeneratorBuilder(this.tree.getDtoGeneratorBuilder(), fields, dtoInstanceSupplier, nestedDtoType), fields[idx]);
    }

    public static class Node {
        private final String fieldName;
        private final DtoGeneratorBuilder<?> dtoGeneratorBuilder;
        private final List<Node> children = new LinkedList<Node>();
        private final FieldGeneratorsProvider fieldGeneratorsProvider;

        private Node(DtoGeneratorBuilder<?> generatorBuilder, String fieldName) {
            this.dtoGeneratorBuilder = generatorBuilder;
            this.fieldName = fieldName;
            this.fieldGeneratorsProvider = generatorBuilder.getFieldGeneratorsProvider();
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public DtoGeneratorBuilder<?> getDtoGeneratorBuilder() {
            return this.dtoGeneratorBuilder;
        }

        public List<Node> getChildren() {
            return this.children;
        }

        public FieldGeneratorsProvider getFieldGeneratorsProvider() {
            return this.fieldGeneratorsProvider;
        }
    }
}

