/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator;

import java.util.function.Supplier;
import org.laoruga.dtogenerator.util.ReflectionUtils;

public class DtoInstanceSupplier
implements Supplier<Object> {
    private final ThreadLocal<Object> threadLocalDtoInstance = new ThreadLocal();
    private final Class<?> dtoClass;

    public DtoInstanceSupplier(Class<?> dtoClass) {
        this.dtoClass = dtoClass;
    }

    @Override
    public Object get() {
        if (this.threadLocalDtoInstance.get() == null) {
            this.updateInstance();
        }
        return this.threadLocalDtoInstance.get();
    }

    public void updateInstance() {
        this.threadLocalDtoInstance.set(ReflectionUtils.createInstance(this.dtoClass, new Object[0]));
    }

    public void remove() {
        this.threadLocalDtoInstance.remove();
    }
}

