/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator;

import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ErrorsHolder {
    private Map<Field, Exception> errors;

    Map<Field, Exception> getErrors() {
        if (this.errors == null) {
            this.errors = new LinkedHashMap<Field, Exception>();
        }
        return this.errors;
    }

    public boolean isEmpty() {
        return this.errors == null || this.getErrors().isEmpty();
    }

    public void put(Field field, Exception e) {
        this.getErrors().put(field, e);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        AtomicInteger counter = new AtomicInteger(0);
        return this.getErrors().entrySet().stream().map(fieldExceptionEntry -> "- [" + counter.incrementAndGet() + "] Field: '" + ((Field)fieldExceptionEntry.getKey()).toString() + "'\n- [" + counter.get() + "] Exception:\n" + ExceptionUtils.getStackTrace((Throwable)((Throwable)fieldExceptionEntry.getValue()))).collect(Collectors.joining("\n"));
    }

    public int getErrorsNumber() {
        return this.errors == null ? 0 : this.getErrors().size();
    }
}

