/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.laoruga.dtogenerator.api.generators.Generator;
import org.laoruga.dtogenerator.generator.NestedDtoGenerator;

public class FieldGenerators {
    private final Map<Supplier<?>, GeneratorEntry> fieldGeneratorsMap = new HashMap();
    private final List<NestedGeneratorEntry> nestedDtoGenerators = new LinkedList<NestedGeneratorEntry>();

    public boolean isNestedFieldsExist() {
        return !this.nestedDtoGenerators.isEmpty();
    }

    public boolean isEmpty() {
        return this.fieldGeneratorsMap.isEmpty() && this.nestedDtoGenerators.isEmpty();
    }

    public int size() {
        return this.nestedDtoGenerators.size() + this.fieldGeneratorsMap.values().stream().map(entry -> entry.fieldGeneratorMap.size()).reduce(Integer::sum).orElse(0);
    }

    public String toString() {
        int size = this.size();
        if (size == 0) {
            return "Generators not found";
        }
        StringBuilder resultComment = new StringBuilder(size + " generators for fields:\n");
        AtomicInteger idx = new AtomicInteger(0);
        for (GeneratorEntry entry : this.fieldGeneratorsMap.values()) {
            resultComment.append((CharSequence)resultComment).append(entry.fieldGeneratorMap.keySet().stream().map(i -> idx.incrementAndGet() + ". " + i).collect(Collectors.joining("\n")));
        }
        return resultComment.toString();
    }

    public void addGenerator(Supplier<?> dtoInstanceSupplier, Map<Field, Generator<?>> generatorMap) {
        this.fieldGeneratorsMap.put(dtoInstanceSupplier, new GeneratorEntry(dtoInstanceSupplier, generatorMap));
    }

    public void addGenerator(Field field, Generator<?> generator, Supplier<?> dtoInstanceSupplier) {
        this.fieldGeneratorsMap.putIfAbsent(dtoInstanceSupplier, new GeneratorEntry(dtoInstanceSupplier, new HashMap()));
        this.fieldGeneratorsMap.get(dtoInstanceSupplier).getFieldGeneratorMap().put(field, generator);
    }

    public void addNestedGenerator(Supplier<?> dtoInstanceSupplier, NestedDtoGenerator nestedDtoGenerator, Field field) {
        this.nestedDtoGenerators.add(new NestedGeneratorEntry(dtoInstanceSupplier, nestedDtoGenerator, field));
    }

    public Map<Supplier<?>, GeneratorEntry> getFieldGeneratorsMap() {
        return this.fieldGeneratorsMap;
    }

    public List<NestedGeneratorEntry> getNestedDtoGenerators() {
        return this.nestedDtoGenerators;
    }

    public static class GeneratorEntry {
        final Supplier<?> dtoInstanceSupplier;
        final Map<Field, Generator<?>> fieldGeneratorMap;

        public GeneratorEntry(Supplier<?> dtoInstanceSupplier, Map<Field, Generator<?>> fieldGeneratorMap) {
            this.dtoInstanceSupplier = dtoInstanceSupplier;
            this.fieldGeneratorMap = fieldGeneratorMap;
        }

        public Supplier<?> getDtoInstanceSupplier() {
            return this.dtoInstanceSupplier;
        }

        public Map<Field, Generator<?>> getFieldGeneratorMap() {
            return this.fieldGeneratorMap;
        }
    }

    public static class NestedGeneratorEntry {
        final Supplier<?> dtoInstanceSupplier;
        final NestedDtoGenerator nestedDtoGenerator;
        final Field field;

        public NestedGeneratorEntry(Supplier<?> dtoInstanceSupplier, NestedDtoGenerator nestedDtoGenerator, Field field) {
            this.dtoInstanceSupplier = dtoInstanceSupplier;
            this.nestedDtoGenerator = nestedDtoGenerator;
            this.field = field;
        }

        public Supplier<?> getDtoInstanceSupplier() {
            return this.dtoInstanceSupplier;
        }

        public NestedDtoGenerator getNestedDtoGenerator() {
            return this.nestedDtoGenerator;
        }

        public Field getField() {
            return this.field;
        }
    }
}

