/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.laoruga.dtogenerator.ErrorsHolder;
import org.laoruga.dtogenerator.FieldGenerators;
import org.laoruga.dtogenerator.FieldGeneratorsProvider;
import org.laoruga.dtogenerator.api.generators.Generator;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.generator.NestedDtoGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldGeneratorsPreparer {
    private static final Logger log = LoggerFactory.getLogger(FieldGeneratorsPreparer.class);
    private final FieldGenerators filedGenerators = new FieldGenerators();
    private final ErrorsHolder errorsHolder = new ErrorsHolder();

    void prepareGenerators(Class<?> dtoClass, FieldGeneratorsProvider fieldGeneratorsProvider) {
        this.prepareGenerators(dtoClass, fieldGeneratorsProvider, new HashMap());
        if (!this.errorsHolder.isEmpty()) {
            throw new DtoGeneratorException("'" + this.errorsHolder.getErrorsNumber() + "' error(s) during generators preparation:\n" + this.errorsHolder);
        }
        log.debug(this.filedGenerators.toString());
    }

    private void prepareGenerators(Class<?> dtoClass, FieldGeneratorsProvider fieldGeneratorsProvider, Map<Field, Generator<?>> generatorMap) {
        Supplier<?> dtoInstanceSupplier = fieldGeneratorsProvider.getDtoInstanceSupplier();
        this.filedGenerators.addGenerator(dtoInstanceSupplier, generatorMap);
        if (dtoClass.getSuperclass() != null && dtoClass.getSuperclass() != Object.class) {
            this.prepareGenerators(dtoClass.getSuperclass(), fieldGeneratorsProvider, generatorMap);
        }
        for (Field field : dtoClass.getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers())) {
                log.info("Skipping final field '" + field.getType() + " " + field.getName() + "'");
                continue;
            }
            Optional<Object> maybeGenerator = Optional.empty();
            try {
                maybeGenerator = fieldGeneratorsProvider.getGenerator(field);
            }
            catch (Exception e) {
                this.errorsHolder.put(field, e);
            }
            if (maybeGenerator.isPresent()) {
                Generator generator = (Generator)maybeGenerator.get();
                if (generator instanceof NestedDtoGenerator) {
                    this.prepareGeneratorsForNestedDto(field, (NestedDtoGenerator)generator, dtoInstanceSupplier);
                    continue;
                }
                generatorMap.put(field, generator);
                continue;
            }
            log.debug("Generator not found for field: '" + field.getName() + "'");
        }
    }

    private void prepareGeneratorsForNestedDto(Field field, NestedDtoGenerator nestedDtoGenerator, Supplier<?> dtoInstanceSupplier) {
        FieldGeneratorsProvider nestedFieldGeneratorsProvider = nestedDtoGenerator.getDtoGeneratorBuilderTreeNode().getFieldGeneratorsProvider();
        this.filedGenerators.addNestedGenerator(dtoInstanceSupplier, nestedDtoGenerator, field);
        this.prepareGenerators(field.getType(), nestedFieldGeneratorsProvider, new HashMap());
    }

    FieldGenerators getFiledGenerators() {
        return this.filedGenerators;
    }

    ErrorsHolder getErrorsHolder() {
        return this.errorsHolder;
    }
}

