/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.NonNull;
import org.laoruga.dtogenerator.CustomGeneratorsConfigMapHolder;
import org.laoruga.dtogenerator.DtoGeneratorBuildersTree;
import org.laoruga.dtogenerator.FieldFilter;
import org.laoruga.dtogenerator.RemarksHolder;
import org.laoruga.dtogenerator.api.generators.Generator;
import org.laoruga.dtogenerator.api.generators.custom.CustomGenerator;
import org.laoruga.dtogenerator.config.ConfigurationHolder;
import org.laoruga.dtogenerator.config.dto.DtoGeneratorConfig;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.generator.config.dto.ConfigDto;
import org.laoruga.dtogenerator.generator.providers.GeneratorProvidersMediator;
import org.laoruga.dtogenerator.generator.providers.suppliers.UserGeneratorSuppliers;
import org.laoruga.dtogenerator.rule.RuleInfo;
import org.laoruga.dtogenerator.rule.RulesInfoExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldGeneratorsProvider {
    private static final Logger log = LoggerFactory.getLogger(FieldGeneratorsProvider.class);
    private final ConfigurationHolder configuration;
    private final Supplier<?> dtoInstanceSupplier;
    private final String[] pathFromDtoRoot;
    private final Supplier<DtoGeneratorBuildersTree> dtoGeneratorBuildersTree;
    private final UserGeneratorSuppliers userGeneratorSuppliers;
    private final RulesInfoExtractor rulesInfoExtractor;
    private final GeneratorProvidersMediator generatorProvidersMediator;
    private final RemarksHolder remarksHolder;
    private final CustomGeneratorsConfigMapHolder customGeneratorsConfigMapHolder;
    private final Set<String> ignoredFields;

    FieldGeneratorsProvider(ConfigurationHolder configuration, RemarksHolder remarksHolder, CustomGeneratorsConfigMapHolder customGeneratorsConfigMapHolder, FieldFilter fieldsFilter, String[] pathFromDtoRoot, Supplier<DtoGeneratorBuildersTree> dtoGeneratorBuildersTree, Supplier<?> dtoInstanceSupplier) {
        this.configuration = configuration;
        this.userGeneratorSuppliers = new UserGeneratorSuppliers();
        this.pathFromDtoRoot = pathFromDtoRoot;
        this.rulesInfoExtractor = new RulesInfoExtractor(fieldsFilter);
        this.dtoGeneratorBuildersTree = dtoGeneratorBuildersTree;
        this.generatorProvidersMediator = new GeneratorProvidersMediator(configuration, this.userGeneratorSuppliers, remarksHolder, this.nestedDtoGeneratorBuilderSupplier());
        this.dtoInstanceSupplier = dtoInstanceSupplier;
        this.remarksHolder = remarksHolder;
        this.customGeneratorsConfigMapHolder = customGeneratorsConfigMapHolder;
        this.ignoredFields = new HashSet<String>();
    }

    FieldGeneratorsProvider(FieldGeneratorsProvider copyFrom, RemarksHolder remarksHolder, CustomGeneratorsConfigMapHolder customGeneratorsConfigMapHolder, String[] pathFromDtoRoot, Supplier<?> dtoInstanceSupplier, ConfigurationHolder configurationCopy) {
        this.configuration = configurationCopy;
        this.userGeneratorSuppliers = copyFrom.getUserGeneratorSuppliers();
        this.pathFromDtoRoot = pathFromDtoRoot;
        this.rulesInfoExtractor = copyFrom.getRulesInfoExtractor();
        this.dtoGeneratorBuildersTree = copyFrom.getDtoGeneratorBuildersTree();
        this.dtoInstanceSupplier = dtoInstanceSupplier;
        this.generatorProvidersMediator = new GeneratorProvidersMediator(configurationCopy, this.userGeneratorSuppliers, remarksHolder, this.nestedDtoGeneratorBuilderSupplier());
        this.remarksHolder = remarksHolder;
        this.customGeneratorsConfigMapHolder = customGeneratorsConfigMapHolder;
        this.ignoredFields = new HashSet<String>();
    }

    Optional<Generator<?>> getGenerator(Field field) {
        Optional<Generator<?>> maybeUserGeneratorForType;
        String fieldName = field.getName();
        if (this.ignoredFields.contains(fieldName)) {
            log.debug("Field '" + fieldName + "' ignored.");
            return Optional.empty();
        }
        Optional<Generator<?>> maybeUserGeneratorForField = this.generatorProvidersMediator.getGeneratorOverriddenForField(field);
        if (maybeUserGeneratorForField.isPresent()) {
            Generator<?> generatorForField = maybeUserGeneratorForField.get();
            if (generatorForField instanceof CustomGenerator) {
                this.configuration.getCustomGeneratorsConfigurators().getBuilder(fieldName, generatorForField.getClass()).build().configure((CustomGenerator)generatorForField);
            }
            return Optional.of(generatorForField);
        }
        Optional<RuleInfo> maybeRulesInfo = this.getRuleInfo(field);
        if (maybeRulesInfo.isPresent()) {
            return Optional.of(this.generatorProvidersMediator.getGeneratorByAnnotation(maybeRulesInfo.get()));
        }
        Class<?> fieldType = field.getType();
        DtoGeneratorConfig generatorConfig = this.configuration.getDtoGeneratorConfig();
        if (generatorConfig.getGenerateAllKnownTypes().booleanValue()) {
            return this.generatorProvidersMediator.getGeneratorByType(field, fieldType);
        }
        if (generatorConfig.getGenerateUsersTypes().booleanValue() && (maybeUserGeneratorForType = this.generatorProvidersMediator.getUserGeneratorByType(field, fieldType)).isPresent()) {
            return maybeUserGeneratorForType;
        }
        return Optional.empty();
    }

    void setGeneratorForField(String fieldName, Generator<?> generator) throws DtoGeneratorException {
        this.generatorProvidersMediator.setGeneratorForField(fieldName, generator);
    }

    void setGenerator(Class<?> generatedType, @NonNull Generator<?> generator) {
        if (generator == null) {
            throw new NullPointerException("generator is marked non-null but is null");
        }
        this.generatorProvidersMediator.setGeneratorByType(generatedType, generator);
    }

    void addGroups(String[] groups) {
        this.rulesInfoExtractor.getFieldsGroupFilter().includeGroups(groups);
    }

    void addFieldToIgnore(String field) {
        this.ignoredFields.add(field);
    }

    private Function<String, DtoGeneratorBuildersTree.Node> nestedDtoGeneratorBuilderSupplier() {
        return fieldName -> {
            String[] pathToNestedDtoField = Arrays.copyOf(this.pathFromDtoRoot, this.pathFromDtoRoot.length + 1);
            pathToNestedDtoField[this.pathFromDtoRoot.length] = fieldName;
            return this.dtoGeneratorBuildersTree.get().getNodeLazy(pathToNestedDtoField);
        };
    }

    private Optional<RuleInfo> getRuleInfo(Field field) {
        try {
            return this.rulesInfoExtractor.extractRulesInfo(field);
        }
        catch (Exception e) {
            throw new DtoGeneratorException("Error while extracting rule annotations from the field: '" + field.getType() + " " + field.getName() + "'", e);
        }
    }

    public void setGeneratorConfigForField(String fieldName, ConfigDto generatorConfig) {
        this.configuration.getTypeGeneratorsConfigForField().setGeneratorConfigForField(fieldName, generatorConfig);
    }

    public void setGeneratorConfigForType(Class<?> generatedType, ConfigDto generatorConfig) {
        this.configuration.getTypeGeneratorsConfig().setGeneratorConfigForType(generatedType, generatorConfig);
    }

    ConfigurationHolder getConfiguration() {
        return this.configuration;
    }

    String[] getPathFromDtoRoot() {
        return this.pathFromDtoRoot;
    }

    Supplier<DtoGeneratorBuildersTree> getDtoGeneratorBuildersTree() {
        return this.dtoGeneratorBuildersTree;
    }

    UserGeneratorSuppliers getUserGeneratorSuppliers() {
        return this.userGeneratorSuppliers;
    }

    RulesInfoExtractor getRulesInfoExtractor() {
        return this.rulesInfoExtractor;
    }

    GeneratorProvidersMediator getGeneratorProvidersMediator() {
        return this.generatorProvidersMediator;
    }

    RemarksHolder getRemarksHolder() {
        return this.remarksHolder;
    }

    CustomGeneratorsConfigMapHolder getCustomGeneratorsConfigMapHolder() {
        return this.customGeneratorsConfigMapHolder;
    }

    Set<String> getIgnoredFields() {
        return this.ignoredFields;
    }

    public Supplier<?> getDtoInstanceSupplier() {
        return this.dtoInstanceSupplier;
    }
}

