/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;
import org.laoruga.dtogenerator.api.RuleRemark;
import org.laoruga.dtogenerator.constants.Boundary;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;

public class RemarksHolder {
    private final Map<String, RuleRemark> ruleRemarksMapByField = new HashMap<String, RuleRemark>();
    private final AtomicReference<RuleRemark> ruleRemarkForAnyField;

    public RemarksHolder() {
        this(new AtomicReference<RuleRemark>());
    }

    RemarksHolder(RemarksHolder toCopy) {
        this(new AtomicReference<RuleRemark>(toCopy.ruleRemarkForAnyField.get()));
    }

    private RemarksHolder(AtomicReference<RuleRemark> ruleRemarkForAnyField) {
        this.ruleRemarkForAnyField = ruleRemarkForAnyField;
    }

    void setRuleRemarkForField(@NonNull String filedName, @NonNull RuleRemark ruleRemark) {
        if (filedName == null) {
            throw new NullPointerException("filedName is marked non-null but is null");
        }
        if (ruleRemark == null) {
            throw new NullPointerException("ruleRemark is marked non-null but is null");
        }
        if (this.ruleRemarksMapByField.containsKey(filedName)) {
            throw new DtoGeneratorException("Attempt to overwrite remark from: '" + this.getBoundaryOrNull(filedName) + "' to: '" + ruleRemark + "' for field '" + filedName + "'.");
        }
        this.ruleRemarksMapByField.put(filedName, ruleRemark);
    }

    void setRuleRemarkForAnyField(RuleRemark ruleRemark) {
        if (this.ruleRemarkForAnyField.get() != null && this.ruleRemarkForAnyField.get() != ruleRemark) {
            throw new DtoGeneratorException("Attempt to overwrite remark for all fields from: '" + this.ruleRemarkForAnyField.get() + "' to: '" + ruleRemark + "'.");
        }
        this.ruleRemarkForAnyField.set(ruleRemark);
    }

    public Boundary getBoundaryOrNull(String fieldName) {
        try {
            if (this.ruleRemarksMapByField.containsKey(fieldName)) {
                return (Boundary)this.ruleRemarksMapByField.get(fieldName);
            }
            return (Boundary)this.ruleRemarkForAnyField.get();
        }
        catch (ClassCastException e) {
            throw new DtoGeneratorException("Unexpected error", e);
        }
    }
}

