/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.api.rules;

import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.laoruga.dtogenerator.api.rules.IntegralRules;
import org.laoruga.dtogenerator.api.rules.meta.Rule;
import org.laoruga.dtogenerator.constants.Boundary;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.TYPE_USE})
@Rule
@Repeatable(value=IntegralRules.class)
public @interface IntegralRule {
    public static final Class<?>[] GENERATED_TYPES = new Class[]{Byte.class, Short.class, Integer.class, Long.class, BigInteger.class, AtomicInteger.class, AtomicLong.class};

    public long maxLong() default 0x7FFFFFFFFFFFFFFFL;

    public long minLong() default -9223372036854775808L;

    public int maxInt() default 0x7FFFFFFF;

    public int minInt() default -2147483648;

    public short maxShort() default 32767;

    public short minShort() default -32768;

    public byte maxByte() default 127;

    public byte minByte() default -128;

    public String maxBigInt() default "9223372036854775807";

    public String minBigInt() default "-9223372036854775807";

    public Boundary boundary() default Boundary.RANDOM_VALUE;

    public String group() default "DEFAULT";
}

