/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Supplier;
import org.laoruga.dtogenerator.CustomGeneratorsConfigMapHolder;
import org.laoruga.dtogenerator.RemarksHolder;
import org.laoruga.dtogenerator.api.generators.custom.CustomGenerator;
import org.laoruga.dtogenerator.api.generators.custom.CustomGeneratorArgs;
import org.laoruga.dtogenerator.api.generators.custom.CustomGeneratorBoundary;
import org.laoruga.dtogenerator.api.generators.custom.CustomGeneratorConfigMap;
import org.laoruga.dtogenerator.api.generators.custom.CustomGeneratorDtoDependent;
import org.laoruga.dtogenerator.constants.Boundary;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomGeneratorConfigurator {
    private static final Logger log = LoggerFactory.getLogger(CustomGeneratorConfigurator.class);
    private String[] args;
    private String[] keyValueParams;
    private Supplier<?> dtoInstanceSupplier;
    private RemarksHolder remarksHolder;
    private CustomGeneratorsConfigMapHolder customGeneratorsConfigMapHolder;
    private Boundary boundary;
    private String fieldName;

    public void configure(CustomGenerator<?> generatorInstance) {
        try {
            if (generatorInstance instanceof CustomGeneratorArgs) {
                log.debug("Custom generator args: ' " + (this.args != null ? Arrays.asList(this.args) : "") + " ' have been obtained.");
                ((CustomGeneratorArgs)generatorInstance).setArgs(this.args);
            }
            if (generatorInstance instanceof CustomGeneratorDtoDependent) {
                this.setDto(generatorInstance);
            }
            if (generatorInstance instanceof CustomGeneratorConfigMap) {
                HashMap<String, String> configMap = new HashMap<String, String>();
                if (this.keyValueParams.length != 0) {
                    for (int i = 0; i < this.keyValueParams.length; i += 2) {
                        configMap.put(this.keyValueParams[i], this.keyValueParams[i + 1]);
                    }
                }
                ((CustomGeneratorConfigMap)generatorInstance).setConfigMap(this.customGeneratorsConfigMapHolder.fillConfigMap(this.fieldName, generatorInstance.getClass(), configMap));
            } else if (generatorInstance instanceof CustomGeneratorBoundary) {
                Boundary boundaryOrNull = this.remarksHolder.getBoundaryOrNull(this.fieldName);
                ((CustomGeneratorBoundary)generatorInstance).setBoundary(boundaryOrNull != null ? boundaryOrNull : this.boundary);
            }
        }
        catch (Exception e) {
            throw new DtoGeneratorException("Error while preparing custom generator.", e);
        }
    }

    private void setDto(Object generatorInstance) {
        try {
            ((CustomGeneratorDtoDependent)generatorInstance).setDtoSupplier(this.dtoInstanceSupplier);
        }
        catch (ClassCastException e) {
            throw new DtoGeneratorException("ClassCastException while trying to set basic DTO into DTO dependent custom generator. Perhaps there is wrong argument type is passing into 'setDto' method of generator class. Generator class: '" + generatorInstance.getClass() + "', Passing argument type: '" + this.dtoInstanceSupplier.getClass() + "'", e);
        }
        catch (Exception e) {
            throw new DtoGeneratorException("Exception was thrown while trying to set DTO into DTO dependent custom generator: " + generatorInstance.getClass(), e);
        }
    }

    CustomGeneratorConfigurator(String[] args, String[] keyValueParams, Supplier<?> dtoInstanceSupplier, RemarksHolder remarksHolder, CustomGeneratorsConfigMapHolder customGeneratorsConfigMapHolder, Boundary boundary, String fieldName) {
        this.args = args;
        this.keyValueParams = keyValueParams;
        this.dtoInstanceSupplier = dtoInstanceSupplier;
        this.remarksHolder = remarksHolder;
        this.customGeneratorsConfigMapHolder = customGeneratorsConfigMapHolder;
        this.boundary = boundary;
        this.fieldName = fieldName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String[] args;
        private String[] keyValueParams;
        private Supplier<?> dtoInstanceSupplier;
        private RemarksHolder remarksHolder;
        private CustomGeneratorsConfigMapHolder customGeneratorsConfigMapHolder;
        private Boundary boundary;
        private String fieldName;

        public Builder merge(Builder builder) {
            if (builder.args != null) {
                this.args = builder.args;
            }
            if (builder.boundary != null) {
                this.boundary = builder.boundary;
            }
            return this;
        }

        public Builder keyValueParams(String[] keyValueParams) {
            if (keyValueParams.length % 2 > 0) {
                throw new IllegalArgumentException("Even parameters number expected (key-value pairs), but passed: " + Arrays.asList(keyValueParams));
            }
            this.keyValueParams = keyValueParams;
            return this;
        }

        Builder() {
        }

        public Builder args(String[] args) {
            this.args = args;
            return this;
        }

        public Builder dtoInstanceSupplier(Supplier<?> dtoInstanceSupplier) {
            this.dtoInstanceSupplier = dtoInstanceSupplier;
            return this;
        }

        public Builder remarksHolder(RemarksHolder remarksHolder) {
            this.remarksHolder = remarksHolder;
            return this;
        }

        public Builder customGeneratorsConfigMapHolder(CustomGeneratorsConfigMapHolder customGeneratorsConfigMapHolder) {
            this.customGeneratorsConfigMapHolder = customGeneratorsConfigMapHolder;
            return this;
        }

        public Builder boundary(Boundary boundary) {
            this.boundary = boundary;
            return this;
        }

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public CustomGeneratorConfigurator build() {
            return new CustomGeneratorConfigurator(this.args, this.keyValueParams, this.dtoInstanceSupplier, this.remarksHolder, this.customGeneratorsConfigMapHolder, this.boundary, this.fieldName);
        }

        public String toString() {
            return "CustomGeneratorConfigurator.Builder(args=" + Arrays.deepToString(this.args) + ", keyValueParams=" + Arrays.deepToString(this.keyValueParams) + ", dtoInstanceSupplier=" + this.dtoInstanceSupplier + ", remarksHolder=" + this.remarksHolder + ", customGeneratorsConfigMapHolder=" + this.customGeneratorsConfigMapHolder + ", boundary=" + this.boundary + ", fieldName=" + this.fieldName + ")";
        }
    }
}

