/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.laoruga.dtogenerator.CustomGeneratorsConfigMapHolder;
import org.laoruga.dtogenerator.RemarksHolder;
import org.laoruga.dtogenerator.api.generators.custom.CustomGenerator;
import org.laoruga.dtogenerator.config.CustomGeneratorConfigurator;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;

public class CustomGeneratorsConfigurationHolder {
    private final Supplier<?> dtoInstanceSupplier;
    private final RemarksHolder remarksHolder;
    private final CustomGeneratorsConfigMapHolder customGeneratorsConfigMapHolder;
    private final Map<String, CustomGeneratorConfigurator.Builder> byFieldName;
    private final Map<Class<? extends CustomGenerator<?>>, CustomGeneratorConfigurator.Builder> byGeneratorType;
    private static final String[] EMPTY_ARRAY = new String[0];

    public CustomGeneratorsConfigurationHolder(Supplier<?> dtoInstanceSupplier, RemarksHolder remarksHolder, CustomGeneratorsConfigMapHolder customGeneratorsConfigMapHolder) {
        this.dtoInstanceSupplier = dtoInstanceSupplier;
        this.remarksHolder = remarksHolder;
        this.customGeneratorsConfigMapHolder = customGeneratorsConfigMapHolder;
        this.byFieldName = new HashMap<String, CustomGeneratorConfigurator.Builder>();
        this.byGeneratorType = new HashMap();
    }

    public CustomGeneratorsConfigurationHolder(Supplier<?> dtoInstanceSupplier, RemarksHolder remarksHolder, CustomGeneratorsConfigMapHolder customGeneratorsConfigMapHolder, Map<Class<? extends CustomGenerator<?>>, CustomGeneratorConfigurator.Builder> byGeneratorType) {
        this.dtoInstanceSupplier = dtoInstanceSupplier;
        this.remarksHolder = remarksHolder;
        this.customGeneratorsConfigMapHolder = customGeneratorsConfigMapHolder;
        this.byGeneratorType = byGeneratorType;
        this.byFieldName = new HashMap<String, CustomGeneratorConfigurator.Builder>();
    }

    public synchronized void setConfiguratorBuilder(String fieldName, CustomGeneratorConfigurator.Builder configuratorBuilder) {
        if (this.byFieldName.containsKey(fieldName)) {
            throw new DtoGeneratorException("Custom generator configurator already set for the field: '" + fieldName + "'");
        }
        this.byFieldName.put(fieldName, configuratorBuilder);
    }

    public synchronized void setConfiguratorBuilder(Class<? extends CustomGenerator<?>> customGeneratorClass, CustomGeneratorConfigurator.Builder configuratorBuilder) {
        if (this.byGeneratorType.containsKey(customGeneratorClass)) {
            throw new DtoGeneratorException("Custom generator configurator already set for generator: '" + customGeneratorClass + "'");
        }
        this.byGeneratorType.put(customGeneratorClass, configuratorBuilder);
    }

    public Optional<CustomGeneratorConfigurator.Builder> getBuilder(Class<? extends CustomGenerator<?>> generatorClass) {
        return Optional.ofNullable(this.byGeneratorType.getOrDefault(generatorClass, null));
    }

    public Optional<CustomGeneratorConfigurator.Builder> getBuilder(String fieldName) {
        return Optional.ofNullable(this.byFieldName.getOrDefault(fieldName, null));
    }

    public CustomGeneratorConfigurator.Builder getBuilder(String fieldName, Class<? extends CustomGenerator<?>> generatorClass, String[] args, String[] keyValueParams) {
        CustomGeneratorConfigurator.Builder newBuilder = this.newDefaultBuilder(fieldName).args(args).keyValueParams(keyValueParams);
        this.getBuilder(generatorClass).ifPresent(newBuilder::merge);
        this.getBuilder(fieldName).ifPresent(newBuilder::merge);
        return newBuilder;
    }

    public CustomGeneratorConfigurator.Builder getBuilder(String fieldName, Class<? extends CustomGenerator<?>> generatorClass) {
        CustomGeneratorConfigurator.Builder newBuilder = this.newDefaultBuilder(fieldName);
        this.getBuilder(generatorClass).ifPresent(newBuilder::merge);
        this.getBuilder(fieldName).ifPresent(newBuilder::merge);
        return newBuilder;
    }

    public CustomGeneratorConfigurator.Builder newDefaultBuilder(String fieldName) {
        return CustomGeneratorConfigurator.builder().fieldName(fieldName).args(EMPTY_ARRAY).dtoInstanceSupplier(this.dtoInstanceSupplier).remarksHolder(this.remarksHolder).customGeneratorsConfigMapHolder(this.customGeneratorsConfigMapHolder);
    }

    public void setArgs(Class<? extends CustomGenerator<?>> generatorClass, String[] argsOrNull) {
        CustomGeneratorConfigurator.Builder builder;
        Optional<CustomGeneratorConfigurator.Builder> maybeBuilder = this.getBuilder(generatorClass);
        if (maybeBuilder.isPresent()) {
            builder = maybeBuilder.get();
        } else {
            builder = CustomGeneratorConfigurator.builder().dtoInstanceSupplier(this.dtoInstanceSupplier).remarksHolder(this.remarksHolder);
            this.setConfiguratorBuilder(generatorClass, builder);
        }
        if (argsOrNull != null) {
            builder.args(argsOrNull);
        }
    }

    public void setArgs(String fieldName, String[] argsOrNull) {
        CustomGeneratorConfigurator.Builder builder;
        Optional<CustomGeneratorConfigurator.Builder> maybeBuilder = this.getBuilder(fieldName);
        if (maybeBuilder.isPresent()) {
            builder = maybeBuilder.get();
        } else {
            builder = CustomGeneratorConfigurator.builder().fieldName(fieldName).dtoInstanceSupplier(this.dtoInstanceSupplier).remarksHolder(this.remarksHolder);
            this.setConfiguratorBuilder(fieldName, builder);
        }
        if (argsOrNull != null) {
            builder.args(argsOrNull);
        }
    }

    public Map<Class<? extends CustomGenerator<?>>, CustomGeneratorConfigurator.Builder> getByGeneratorType() {
        return this.byGeneratorType;
    }
}

