/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.config.dto;

import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.laoruga.dtogenerator.config.dto.DtoGeneratorConfigParams;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtoGeneratorFileConfig
extends DtoGeneratorConfigParams {
    private static final Logger log = LoggerFactory.getLogger(DtoGeneratorFileConfig.class);
    private final Properties properties;
    private final String propsFileName;
    private static final String DEFAULT_PREFIX = "default-";

    public DtoGeneratorFileConfig(String propsFile) {
        this.propsFileName = propsFile;
        this.properties = this.loadPropertiesFromFiles();
        this.initConfigDto();
    }

    private Properties loadPropertiesFromFiles() {
        Optional<Properties> defaultProps = DtoGeneratorFileConfig.loadPropertiesFromFile(DtoGeneratorFileConfig.class.getClassLoader(), DEFAULT_PREFIX + this.propsFileName);
        Optional<Properties> customProps = DtoGeneratorFileConfig.loadPropertiesFromFile(Thread.currentThread().getContextClassLoader(), this.propsFileName);
        Properties props = defaultProps.orElseGet(Properties::new);
        customProps.ifPresent(props::putAll);
        return props;
    }

    private void initConfigDto() {
        this.setMaxFailuresNumberDuringDtoGeneration(Integer.parseInt(this.getProperty("maxFailuresNumberDuringDtoGeneration")));
        this.setMaxCollectionGenerationCycles(Integer.parseInt(this.getProperty("maxCollectionGenerationCycles")));
        this.setGenerateAllKnownTypes(Boolean.parseBoolean(this.getProperty("generateAllKnownTypes")));
        this.setGenerateUsersTypes(Boolean.parseBoolean(this.getProperty("generateUsersTypes")));
    }

    private String getProperty(String name) {
        return Objects.requireNonNull(this.properties.getProperty(name), "Property '" + name + "' not found in the: '" + DEFAULT_PREFIX + this.propsFileName + "' ()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<Properties> loadPropertiesFromFile(ClassLoader classLoader, String fileName) {
        Properties properties = new Properties();
        URL resource = classLoader.getResource(fileName);
        if (resource == null) {
            return Optional.empty();
        }
        try (InputStream propertiesStream = classLoader.getResourceAsStream(fileName);){
            log.debug("Reading properties from {}", (Object)resource);
            properties.load(propertiesStream);
            Optional<Properties> optional = Optional.of(properties);
            return optional;
        }
        catch (Exception e) {
            throw new DtoGeneratorException("Failed to read properties file '" + fileName + "' from classpath", e);
        }
    }
}

