/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.config.types;

import com.google.common.primitives.Primitives;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.laoruga.dtogenerator.api.rules.DecimalRule;
import org.laoruga.dtogenerator.api.rules.EnumRule;
import org.laoruga.dtogenerator.api.rules.IntegralRule;
import org.laoruga.dtogenerator.api.rules.StringRule;
import org.laoruga.dtogenerator.config.types.TypeGeneratorsConfigSupplier;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.generator.config.dto.ArrayConfig;
import org.laoruga.dtogenerator.generator.config.dto.CollectionConfig;
import org.laoruga.dtogenerator.generator.config.dto.ConfigDto;
import org.laoruga.dtogenerator.generator.config.dto.DecimalCommonConfig;
import org.laoruga.dtogenerator.generator.config.dto.EnumConfig;
import org.laoruga.dtogenerator.generator.config.dto.IntegralConfigCommonConfig;
import org.laoruga.dtogenerator.generator.config.dto.MapConfig;
import org.laoruga.dtogenerator.generator.config.dto.StringConfig;
import org.laoruga.dtogenerator.generator.config.dto.datetime.DateTimeConfig;

public class TypeGeneratorsConfigLazy
implements TypeGeneratorsConfigSupplier {
    private final Map<Class<?>, ConfigDto> configMap = new HashMap();

    public ConfigDto getOrNull(Class<?> generatedType) {
        if (this.configMap.containsKey(generatedType = Primitives.wrap(generatedType))) {
            return this.configMap.get(generatedType);
        }
        for (Map.Entry<Class<?>, ConfigDto> typeSupplierEntry : this.configMap.entrySet()) {
            if (!typeSupplierEntry.getKey().isAssignableFrom(generatedType)) continue;
            return typeSupplierEntry.getValue();
        }
        return null;
    }

    @Override
    public StringConfig getStringConfig() {
        return (StringConfig)this.getConfigLazy(StringRule.GENERATED_TYPE, StringConfig::new);
    }

    @Override
    public IntegralConfigCommonConfig getIntegralConfig() {
        return (IntegralConfigCommonConfig)this.getConfigLazy(IntegralRule.GENERATED_TYPES, IntegralConfigCommonConfig::new);
    }

    @Override
    public DecimalCommonConfig getDecimalConfig() {
        return (DecimalCommonConfig)this.getConfigLazy(DecimalRule.GENERATED_TYPES, DecimalCommonConfig::new);
    }

    @Override
    public EnumConfig getEnumConfig() {
        return (EnumConfig)this.getConfigLazy(EnumRule.GENERATED_TYPE, EnumConfig::new);
    }

    @Override
    public DateTimeConfig getDateTimeConfig(Class<? extends Temporal> dateTimeType) {
        return (DateTimeConfig)this.getConfigLazy(dateTimeType, DateTimeConfig::new);
    }

    @Override
    public CollectionConfig getCollectionConfig(Class<? extends Collection> generatedType) {
        return (CollectionConfig)this.getConfigLazy(generatedType, CollectionConfig::new);
    }

    @Override
    public ArrayConfig getArrayConfig(Class<?> generatedType) {
        return (ArrayConfig)this.getConfigLazy(generatedType, ArrayConfig::new);
    }

    @Override
    public MapConfig getMapConfig(Class<? extends Map> generatedType) {
        return (MapConfig)this.getConfigLazy(generatedType, MapConfig::new);
    }

    private ConfigDto getConfigLazy(Class<?> generatedType, Supplier<ConfigDto> configSupplier) {
        if (!this.configMap.containsKey(generatedType)) {
            this.configMap.put(generatedType, configSupplier.get());
        }
        return this.configMap.get(generatedType);
    }

    private ConfigDto getConfigLazy(Class<?>[] generatedTypes, Supplier<ConfigDto> configSupplier) {
        ConfigDto configDto = configSupplier.get();
        for (Class<?> generatedType : generatedTypes) {
            if (this.configMap.containsKey(generatedType)) continue;
            this.configMap.putIfAbsent(generatedType, configDto);
        }
        return Objects.requireNonNull(this.configMap.get(generatedTypes[0]));
    }

    public void setGeneratorConfigForType(Class<?> generatedType, ConfigDto generatorConfig) {
        if (this.configMap.containsKey(generatedType)) {
            throw new DtoGeneratorException("Generator config '" + generatorConfig.getClass() + "' already has been set explicitly for type: '" + generatedType + "'");
        }
        this.configMap.put(generatedType, generatorConfig);
    }

    Map<Class<?>, ConfigDto> getConfigMap() {
        return this.configMap;
    }
}

