/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.config.types;

import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.laoruga.dtogenerator.api.rules.ArrayRule;
import org.laoruga.dtogenerator.api.rules.BooleanRule;
import org.laoruga.dtogenerator.api.rules.CollectionRule;
import org.laoruga.dtogenerator.api.rules.DecimalRule;
import org.laoruga.dtogenerator.api.rules.EnumRule;
import org.laoruga.dtogenerator.api.rules.IntegralRule;
import org.laoruga.dtogenerator.api.rules.MapRule;
import org.laoruga.dtogenerator.api.rules.StringRule;
import org.laoruga.dtogenerator.api.rules.datetime.DateTimeRule;
import org.laoruga.dtogenerator.constants.RulesInstance;
import org.laoruga.dtogenerator.generator.config.dto.ArrayConfig;
import org.laoruga.dtogenerator.generator.config.dto.BooleanConfig;
import org.laoruga.dtogenerator.generator.config.dto.CollectionConfig;
import org.laoruga.dtogenerator.generator.config.dto.ConfigDto;
import org.laoruga.dtogenerator.generator.config.dto.DecimalConfig;
import org.laoruga.dtogenerator.generator.config.dto.EnumConfig;
import org.laoruga.dtogenerator.generator.config.dto.IntegralConfig;
import org.laoruga.dtogenerator.generator.config.dto.MapConfig;
import org.laoruga.dtogenerator.generator.config.dto.StringConfig;
import org.laoruga.dtogenerator.generator.config.dto.datetime.DateTimeConfig;
import org.laoruga.dtogenerator.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TypeGeneratorsDefaultConfigSupplier {
    private static final Logger log = LoggerFactory.getLogger(TypeGeneratorsDefaultConfigSupplier.class);
    private static final Map<Class<?>, Supplier<ConfigDto>> GENERATED_TYPE_TO_DEFAULT_CONFIG_NEW_INSTANCE_SUPPLIER;

    public static Optional<Supplier<ConfigDto>> getDefaultConfigSupplier(Class<?> generatedType) {
        if (!GENERATED_TYPE_TO_DEFAULT_CONFIG_NEW_INSTANCE_SUPPLIER.containsKey(generatedType)) {
            for (Map.Entry<Class<?>, Supplier<ConfigDto>> typeSupplierEntry : GENERATED_TYPE_TO_DEFAULT_CONFIG_NEW_INSTANCE_SUPPLIER.entrySet()) {
                if (!typeSupplierEntry.getKey().isAssignableFrom(generatedType)) continue;
                return Optional.of(typeSupplierEntry.getValue());
            }
            log.info("Unable to get default config. Unknown type: " + generatedType);
            return Optional.empty();
        }
        return Optional.of(GENERATED_TYPE_TO_DEFAULT_CONFIG_NEW_INSTANCE_SUPPLIER.get(generatedType));
    }

    private static void add(Map<Class<?>, Supplier<ConfigDto>> generatedTypeToConfigSupplier, Class<?>[] generatedTypes, Annotation rule, Class<? extends ConfigDto> configClass, boolean typeAsArgument) {
        for (Class<?> generatedType : generatedTypes) {
            TypeGeneratorsDefaultConfigSupplier.add(generatedTypeToConfigSupplier, generatedType, rule, configClass, typeAsArgument);
        }
    }

    private static void add(Map<Class<?>, Supplier<ConfigDto>> generatedTypeToConfigSupplier, Class<?> generatedType, Annotation rule, Class<? extends ConfigDto> configClass, boolean typeAsArgument) {
        if (typeAsArgument) {
            generatedTypeToConfigSupplier.put(generatedType, () -> (ConfigDto)ReflectionUtils.createInstance(configClass, rule, generatedType));
        } else {
            generatedTypeToConfigSupplier.put(generatedType, () -> (ConfigDto)ReflectionUtils.createInstance(configClass, rule));
        }
    }

    static {
        HashMap configSupplier = new HashMap(10);
        TypeGeneratorsDefaultConfigSupplier.add(configSupplier, BooleanRule.GENERATED_TYPE, (Annotation)RulesInstance.BOOLEAN_RULE, BooleanConfig.class, false);
        TypeGeneratorsDefaultConfigSupplier.add(configSupplier, new Class[]{StringRule.GENERATED_TYPE}, (Annotation)RulesInstance.STRING_RULE, StringConfig.class, false);
        TypeGeneratorsDefaultConfigSupplier.add(configSupplier, IntegralRule.GENERATED_TYPES, (Annotation)RulesInstance.NUMBER_RULE, IntegralConfig.class, true);
        TypeGeneratorsDefaultConfigSupplier.add(configSupplier, DecimalRule.GENERATED_TYPES, (Annotation)RulesInstance.DECIMAL_RULE, DecimalConfig.class, true);
        TypeGeneratorsDefaultConfigSupplier.add(configSupplier, DateTimeRule.GENERATED_TYPE, (Annotation)RulesInstance.DATE_TIME_RULE, DateTimeConfig.class, false);
        TypeGeneratorsDefaultConfigSupplier.add(configSupplier, EnumRule.GENERATED_TYPE, (Annotation)RulesInstance.ENUM_RULE, EnumConfig.class, false);
        TypeGeneratorsDefaultConfigSupplier.add(configSupplier, CollectionRule.GENERATED_TYPE, (Annotation)RulesInstance.COLLECTION_RULE, CollectionConfig.class, false);
        TypeGeneratorsDefaultConfigSupplier.add(configSupplier, MapRule.GENERATED_TYPE, (Annotation)RulesInstance.MAP_RULE, MapConfig.class, false);
        TypeGeneratorsDefaultConfigSupplier.add(configSupplier, ArrayRule.GENERATED_TYPES, (Annotation)RulesInstance.ARRAY_RULE, ArrayConfig.class, true);
        GENERATED_TYPE_TO_DEFAULT_CONFIG_NEW_INSTANCE_SUPPLIER = ImmutableMap.copyOf(configSupplier);
    }
}

