/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.constants;

import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.laoruga.dtogenerator.api.rules.ArrayRule;
import org.laoruga.dtogenerator.api.rules.BooleanRule;
import org.laoruga.dtogenerator.api.rules.CollectionRule;
import org.laoruga.dtogenerator.api.rules.CustomRule;
import org.laoruga.dtogenerator.api.rules.DecimalRule;
import org.laoruga.dtogenerator.api.rules.Entry;
import org.laoruga.dtogenerator.api.rules.EnumRule;
import org.laoruga.dtogenerator.api.rules.IntegralRule;
import org.laoruga.dtogenerator.api.rules.MapRule;
import org.laoruga.dtogenerator.api.rules.NestedDtoRule;
import org.laoruga.dtogenerator.api.rules.StringRule;
import org.laoruga.dtogenerator.api.rules.datetime.DateTimeRule;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.util.dummy.DummyCustomGenerator;

public final class RulesInstance {
    @BooleanRule
    @StringRule
    @IntegralRule
    @DecimalRule
    @EnumRule
    @DateTimeRule
    @CollectionRule(element=@Entry)
    @MapRule(key=@Entry, value=@Entry)
    @ArrayRule(element=@Entry)
    @CustomRule(generatorClass=DummyCustomGenerator.class)
    @NestedDtoRule
    private static final Object ANNOTATIONS = null;
    public static final BooleanRule BOOLEAN_RULE;
    public static final StringRule STRING_RULE;
    public static final IntegralRule NUMBER_RULE;
    public static final EnumRule ENUM_RULE;
    public static final DecimalRule DECIMAL_RULE;
    public static final DateTimeRule DATE_TIME_RULE;
    public static final CollectionRule COLLECTION_RULE;
    public static final ArrayRule ARRAY_RULE;
    public static final MapRule MAP_RULE;
    public static final CustomRule CUSTOM_RULE;
    public static final NestedDtoRule NESTED_DTO_RULE;
    public static final IntegralRule NUMBER_RULE_ZEROS;
    public static final Map<Class<? extends Annotation>, Annotation> INSTANCES_MAP;

    private static <T extends Annotation> T getAnnotationInstance(Field field, Map<Class<? extends Annotation>, Annotation> instances, Class<T> annotationClass) {
        Annotation instance = (Annotation)Objects.requireNonNull(field.getDeclaredAnnotation(annotationClass), "Annotation instance not set for an annotation class: '" + annotationClass + "'");
        instances.put(annotationClass, instance);
        return (T)instance;
    }

    private RulesInstance() {
    }

    static {
        try {
            Field annotations = RulesInstance.class.getDeclaredField("ANNOTATIONS");
            HashMap<Class<? extends Annotation>, Annotation> instances = new HashMap<Class<? extends Annotation>, Annotation>();
            BOOLEAN_RULE = RulesInstance.getAnnotationInstance(annotations, instances, BooleanRule.class);
            STRING_RULE = RulesInstance.getAnnotationInstance(annotations, instances, StringRule.class);
            NUMBER_RULE = RulesInstance.getAnnotationInstance(annotations, instances, IntegralRule.class);
            NUMBER_RULE_ZEROS = RulesInstance.getAnnotationInstance(annotations, instances, IntegralRule.class);
            ENUM_RULE = RulesInstance.getAnnotationInstance(annotations, instances, EnumRule.class);
            DECIMAL_RULE = RulesInstance.getAnnotationInstance(annotations, instances, DecimalRule.class);
            DATE_TIME_RULE = RulesInstance.getAnnotationInstance(annotations, instances, DateTimeRule.class);
            COLLECTION_RULE = RulesInstance.getAnnotationInstance(annotations, instances, CollectionRule.class);
            MAP_RULE = RulesInstance.getAnnotationInstance(annotations, instances, MapRule.class);
            ARRAY_RULE = RulesInstance.getAnnotationInstance(annotations, instances, ArrayRule.class);
            CUSTOM_RULE = RulesInstance.getAnnotationInstance(annotations, instances, CustomRule.class);
            NESTED_DTO_RULE = RulesInstance.getAnnotationInstance(annotations, instances, NestedDtoRule.class);
            INSTANCES_MAP = ImmutableMap.copyOf(instances);
        }
        catch (Exception e) {
            throw new DtoGeneratorException("Unexpected error while initialisation.", e);
        }
    }
}

