/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator;

import java.lang.reflect.Array;
import java.util.Objects;
import org.laoruga.dtogenerator.api.RuleRemark;
import org.laoruga.dtogenerator.api.generators.Generator;
import org.laoruga.dtogenerator.api.generators.ListGenerator;
import org.laoruga.dtogenerator.constants.Boundary;
import org.laoruga.dtogenerator.generator.config.dto.ArrayConfig;
import org.laoruga.dtogenerator.util.RandomUtils;

public class ArrayGenerator
implements ListGenerator {
    private int minSize;
    private int maxSize;
    private Class<?> elementType;
    private Generator<?> elementGenerator;
    private RuleRemark ruleRemark;

    public ArrayGenerator(ArrayConfig config) {
        this.minSize = config.getMinSize();
        this.maxSize = config.getMaxSize();
        this.elementType = Objects.requireNonNull(config.getElementType(), "Array element type must be set");
        this.elementGenerator = Objects.requireNonNull(config.getElementGenerator(), "Array element generator must be set");
        this.ruleRemark = Objects.requireNonNull(config.getRuleRemark(), "Unexpected error, rule remark haven't set.");
    }

    @Override
    public Object generate() {
        int size;
        switch ((Boundary)this.ruleRemark) {
            case MIN_VALUE: {
                size = this.minSize;
                break;
            }
            case MAX_VALUE: {
                size = this.maxSize;
                break;
            }
            case RANDOM_VALUE: 
            case NOT_DEFINED: {
                size = RandomUtils.nextInt(this.minSize, this.maxSize);
                break;
            }
            case NULL_VALUE: {
                return null;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + this.ruleRemark);
            }
        }
        Object newArray = Array.newInstance(this.elementType, size);
        for (int generatedElementsNumber = 0; generatedElementsNumber != size; ++generatedElementsNumber) {
            Array.set(newArray, generatedElementsNumber, this.elementGenerator.generate());
        }
        return newArray;
    }

    @Override
    public Generator<?> getElementGenerator() {
        return this.elementGenerator;
    }

    public ArrayGenerator(int minSize, int maxSize, Class<?> elementType, Generator<?> elementGenerator, RuleRemark ruleRemark) {
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.elementType = elementType;
        this.elementGenerator = elementGenerator;
        this.ruleRemark = ruleRemark;
    }
}

