/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator;

import org.laoruga.dtogenerator.api.RuleRemark;
import org.laoruga.dtogenerator.api.generators.Generator;
import org.laoruga.dtogenerator.constants.Boundary;
import org.laoruga.dtogenerator.generator.config.dto.BooleanConfig;
import org.laoruga.dtogenerator.util.RandomUtils;

public class BooleanGenerator
implements Generator<Boolean> {
    private final double trueProbability;
    private final RuleRemark ruleRemark;

    public BooleanGenerator(BooleanConfig configDto) {
        this.trueProbability = configDto.getTrueProbability();
        this.ruleRemark = configDto.getRuleRemark();
    }

    @Override
    public Boolean generate() {
        switch ((Boundary)this.ruleRemark) {
            case MIN_VALUE: {
                return false;
            }
            case MAX_VALUE: {
                return true;
            }
            case RANDOM_VALUE: 
            case NOT_DEFINED: {
                return RandomUtils.RANDOM.nextDouble() < this.trueProbability;
            }
            case NULL_VALUE: {
                return null;
            }
        }
        throw new IllegalStateException("Unexpected value " + this.ruleRemark);
    }

    public BooleanGenerator(double trueProbability, RuleRemark ruleRemark) {
        this.trueProbability = trueProbability;
        this.ruleRemark = ruleRemark;
    }
}

