/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import org.laoruga.dtogenerator.api.RuleRemark;
import org.laoruga.dtogenerator.api.generators.Generator;
import org.laoruga.dtogenerator.api.generators.ListGenerator;
import org.laoruga.dtogenerator.config.dto.DtoGeneratorStaticConfig;
import org.laoruga.dtogenerator.constants.Boundary;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.generator.config.dto.CollectionConfig;
import org.laoruga.dtogenerator.util.RandomUtils;

public class CollectionGenerator
implements ListGenerator {
    private final int minSize;
    private final int maxSize;
    private final Supplier<Collection<Object>> collectionInstanceSupplier;
    private final Generator<Object> elementGenerator;
    private final RuleRemark ruleRemark;

    public CollectionGenerator(CollectionConfig collectionConfig) {
        this.minSize = collectionConfig.getMinSize();
        this.maxSize = collectionConfig.getMaxSize();
        this.collectionInstanceSupplier = Objects.requireNonNull(collectionConfig.getCollectionInstanceSupplier(), "Collection instance must be set.");
        this.elementGenerator = Objects.requireNonNull(collectionConfig.getElementGenerator(), "Collection element generator must be set");
        this.ruleRemark = Objects.requireNonNull(collectionConfig.getRuleRemark(), "Unexpected error, rule remark haven't set.");
    }

    @Override
    public Collection<Object> generate() {
        int size;
        Collection<Object> collectionInstance = this.collectionInstanceSupplier.get();
        int maxAttempts = DtoGeneratorStaticConfig.getInstance().getDtoGeneratorConfig().getMaxCollectionGenerationCycles();
        switch ((Boundary)this.ruleRemark) {
            case MIN_VALUE: {
                size = this.minSize;
                break;
            }
            case MAX_VALUE: {
                size = this.maxSize;
                break;
            }
            case RANDOM_VALUE: 
            case NOT_DEFINED: {
                size = RandomUtils.nextInt(this.minSize, this.maxSize);
                break;
            }
            case NULL_VALUE: {
                return null;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + this.ruleRemark);
            }
        }
        int ineffectiveAttempts = 0;
        while (collectionInstance.size() < size) {
            int prevSize = collectionInstance.size();
            collectionInstance.add(this.elementGenerator.generate());
            if (prevSize != collectionInstance.size() || ++ineffectiveAttempts != maxAttempts) continue;
            throw new DtoGeneratorException("Expected size: '" + size + "' of collection: '" + collectionInstance.getClass() + "' can't be reached. After '" + ineffectiveAttempts + "' attempts collection has size: '" + collectionInstance.size() + "'");
        }
        return collectionInstance;
    }

    public Generator<Object> getElementGenerator() {
        return this.elementGenerator;
    }

    public CollectionGenerator(int minSize, int maxSize, Supplier<Collection<Object>> collectionInstanceSupplier, Generator<Object> elementGenerator, RuleRemark ruleRemark) {
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.collectionInstanceSupplier = collectionInstanceSupplier;
        this.elementGenerator = elementGenerator;
        this.ruleRemark = ruleRemark;
    }
}

