/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator;

import java.time.temporal.Temporal;
import java.util.List;
import org.laoruga.dtogenerator.api.RuleRemark;
import org.laoruga.dtogenerator.api.generators.Generator;
import org.laoruga.dtogenerator.generator.config.dto.datetime.ChronoConfig;
import org.laoruga.dtogenerator.generator.config.dto.datetime.DateTimeConfig;
import org.laoruga.dtogenerator.util.ReflectionUtils;

public class DateTimeGenerator
implements Generator<Temporal> {
    private final List<ChronoConfig> chronoUnitConfigList;
    private final RuleRemark ruleRemark;
    private final Class<? extends Temporal> generatedType;

    public DateTimeGenerator(DateTimeConfig config) {
        this.chronoUnitConfigList = config.getChronoUnitConfigList();
        this.ruleRemark = config.getRuleRemark();
        this.generatedType = config.getGeneratedType();
    }

    @Override
    public Temporal generate() {
        Temporal now = ReflectionUtils.callStaticMethod("now", this.generatedType, Temporal.class);
        if (this.chronoUnitConfigList != null) {
            for (ChronoConfig chronoUnitConfig : this.chronoUnitConfigList) {
                now = chronoUnitConfig.adjust(now, this.ruleRemark);
            }
        }
        return now;
    }

    public DateTimeGenerator(List<ChronoConfig> chronoUnitConfigList, RuleRemark ruleRemark, Class<? extends Temporal> generatedType) {
        this.chronoUnitConfigList = chronoUnitConfigList;
        this.ruleRemark = ruleRemark;
        this.generatedType = generatedType;
    }
}

