/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator;

import org.laoruga.dtogenerator.api.RuleRemark;
import org.laoruga.dtogenerator.api.generators.Generator;
import org.laoruga.dtogenerator.constants.Boundary;
import org.laoruga.dtogenerator.generator.config.dto.DecimalConfig;
import org.laoruga.dtogenerator.util.RandomUtils;

public class DecimalGenerator
implements Generator<Number> {
    private final Number maxValue;
    private final Number minValue;
    private final int precision;
    private final RuleRemark ruleRemark;

    public DecimalGenerator(DecimalConfig config) {
        this.maxValue = config.getMaxValue();
        this.minValue = config.getMinValue();
        this.precision = config.getPrecision();
        this.ruleRemark = config.getRuleRemark();
    }

    @Override
    public Number generate() {
        switch ((Boundary)this.ruleRemark) {
            case MIN_VALUE: {
                return this.minValue;
            }
            case MAX_VALUE: {
                return this.maxValue;
            }
            case NULL_VALUE: {
                return null;
            }
            case RANDOM_VALUE: 
            case NOT_DEFINED: {
                return RandomUtils.nextNumberDecimal(this.minValue, this.maxValue, this.precision);
            }
        }
        throw new IllegalStateException("Unexpected value " + this.ruleRemark);
    }

    public DecimalGenerator(Number maxValue, Number minValue, int precision, RuleRemark ruleRemark) {
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.precision = precision;
        this.ruleRemark = ruleRemark;
    }
}

