/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Collectors;
import org.laoruga.dtogenerator.api.RuleRemark;
import org.laoruga.dtogenerator.api.generators.Generator;
import org.laoruga.dtogenerator.constants.Boundary;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.generator.config.dto.EnumConfig;
import org.laoruga.dtogenerator.util.RandomUtils;

public class EnumGenerator
implements Generator<Enum> {
    private final String[] sortedEnumNamesSelection;
    private final Map<String, Enum<?>> allEnumValues;
    private final RuleRemark ruleRemark;
    private int numberOfEnumConstantsOfMinLength = 0;
    private int numberOfEnumConstantsOfMaxLength = 0;

    public EnumGenerator(EnumConfig enumConfig) {
        String[] enumConstantNames;
        if (enumConfig.getEnumClass() == null) {
            throw new DtoGeneratorException("Enum class wasn't set for generator.");
        }
        this.allEnumValues = Arrays.stream(enumConfig.getEnumClass().getEnumConstants()).collect(Collectors.toMap(Enum::name, v -> v));
        this.ruleRemark = enumConfig.getRuleRemark();
        if (enumConfig.getPossibleEnumNames().length == 0) {
            enumConstantNames = (String[])Arrays.stream(enumConfig.getEnumClass().getEnumConstants()).map(Enum::name).toArray(String[]::new);
        } else {
            enumConstantNames = enumConfig.getPossibleEnumNames();
            this.validateEnumNames(enumConstantNames, enumConfig.getEnumClass());
        }
        this.sortedEnumNamesSelection = (String[])Arrays.stream(enumConstantNames).sorted(Comparator.comparing(String::length)).toArray(String[]::new);
    }

    @Override
    public Enum<?> generate() {
        String enumConstantName;
        switch ((Boundary)this.ruleRemark) {
            case MIN_VALUE: {
                if (this.numberOfEnumConstantsOfMinLength == 0) {
                    this.numberOfEnumConstantsOfMinLength = this.countNumberOfEnumConstantsOfMinLength();
                }
                int randomIdx = RandomUtils.nextInt(0, this.numberOfEnumConstantsOfMinLength - 1);
                enumConstantName = this.sortedEnumNamesSelection[randomIdx];
                break;
            }
            case MAX_VALUE: {
                if (this.numberOfEnumConstantsOfMaxLength == 0) {
                    this.numberOfEnumConstantsOfMaxLength = this.countNumberOfEnumConstantsOfMaxLength();
                }
                int randomIdx = RandomUtils.nextInt(this.sortedEnumNamesSelection.length - this.numberOfEnumConstantsOfMaxLength, this.sortedEnumNamesSelection.length - 1);
                enumConstantName = this.sortedEnumNamesSelection[randomIdx];
                break;
            }
            case NULL_VALUE: {
                return null;
            }
            case RANDOM_VALUE: 
            case NOT_DEFINED: {
                enumConstantName = this.sortedEnumNamesSelection[RandomUtils.nextInt(0, this.sortedEnumNamesSelection.length - 1)];
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value " + this.ruleRemark);
            }
        }
        return this.allEnumValues.get(enumConstantName);
    }

    private void validateEnumNames(String[] enumConstantNames, Class<? extends Enum<?>> enumClass) {
        for (String selectedEnumName : enumConstantNames) {
            if (this.allEnumValues.containsKey(selectedEnumName)) continue;
            throw new DtoGeneratorException("Enum constant with name: '" + selectedEnumName + "' not found in the Class: '" + enumClass + "'");
        }
    }

    private int countNumberOfEnumConstantsOfMinLength() {
        int number = 1;
        int minLength = this.sortedEnumNamesSelection[0].length();
        for (int i = 1; i < this.sortedEnumNamesSelection.length && this.sortedEnumNamesSelection[i].length() == minLength; ++i) {
            ++number;
        }
        return number;
    }

    private int countNumberOfEnumConstantsOfMaxLength() {
        int number = 1;
        int maxLength = this.sortedEnumNamesSelection[this.sortedEnumNamesSelection.length - 1].length();
        for (int i = this.sortedEnumNamesSelection.length - 2; i >= 0 && this.sortedEnumNamesSelection[i].length() == maxLength; --i) {
            ++number;
        }
        return number;
    }

    public EnumGenerator(String[] sortedEnumNamesSelection, Map<String, Enum<?>> allEnumValues, RuleRemark ruleRemark, int numberOfEnumConstantsOfMinLength, int numberOfEnumConstantsOfMaxLength) {
        this.sortedEnumNamesSelection = sortedEnumNamesSelection;
        this.allEnumValues = allEnumValues;
        this.ruleRemark = ruleRemark;
        this.numberOfEnumConstantsOfMinLength = numberOfEnumConstantsOfMinLength;
        this.numberOfEnumConstantsOfMaxLength = numberOfEnumConstantsOfMaxLength;
    }
}

