/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator;

import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.laoruga.dtogenerator.api.RuleRemark;
import org.laoruga.dtogenerator.api.generators.Generator;
import org.laoruga.dtogenerator.config.dto.DtoGeneratorStaticConfig;
import org.laoruga.dtogenerator.constants.Boundary;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.generator.config.dto.MapConfig;
import org.laoruga.dtogenerator.util.RandomUtils;

public class MapGenerator
implements Generator<Map<Object, Object>> {
    private Integer minSize;
    private Integer maxSize;
    private Supplier<Map<Object, Object>> mapInstanceSupplier;
    private Generator<Object> keyGenerator;
    private Generator<Object> valueGenerator;
    private RuleRemark ruleRemark;

    public MapGenerator(MapConfig config) {
        this.minSize = config.getMinSize();
        this.maxSize = config.getMaxSize();
        this.mapInstanceSupplier = Objects.requireNonNull(config.getMapInstanceSupplier(), "Map instance supplier must be set");
        this.keyGenerator = Objects.requireNonNull(config.getKeyGenerator(), "Key generator must be set.");
        this.valueGenerator = Objects.requireNonNull(config.getValueGenerator(), "Value generator must be set.");
        this.ruleRemark = Objects.requireNonNull(config.getRuleRemark(), "Unexpected error, rule remark haven't set.");
    }

    @Override
    public Map<Object, Object> generate() {
        int size;
        Map<Object, Object> mapInstance = this.mapInstanceSupplier.get();
        int maxAttempts = DtoGeneratorStaticConfig.getInstance().getDtoGeneratorConfig().getMaxCollectionGenerationCycles();
        switch ((Boundary)this.ruleRemark) {
            case MIN_VALUE: {
                size = this.minSize;
                break;
            }
            case MAX_VALUE: {
                size = this.maxSize;
                break;
            }
            case RANDOM_VALUE: 
            case NOT_DEFINED: {
                size = RandomUtils.nextInt(this.minSize, this.maxSize);
                break;
            }
            case NULL_VALUE: {
                return null;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + this.ruleRemark);
            }
        }
        int attempts = 0;
        while (mapInstance.size() < size) {
            Object key = this.keyGenerator.generate();
            if (mapInstance.containsKey(key)) {
                if (attempts >= maxAttempts) {
                    throw new DtoGeneratorException("Expected size: '" + size + "' of map: '" + mapInstance.getClass() + "' can't be reached. After '" + attempts + "' attempts map has size: '" + mapInstance.size() + "'");
                }
                ++attempts;
                continue;
            }
            mapInstance.put(key, this.valueGenerator.generate());
        }
        return mapInstance;
    }

    public MapGenerator(Integer minSize, Integer maxSize, Supplier<Map<Object, Object>> mapInstanceSupplier, Generator<Object> keyGenerator, Generator<Object> valueGenerator, RuleRemark ruleRemark) {
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.mapInstanceSupplier = mapInstanceSupplier;
        this.keyGenerator = keyGenerator;
        this.valueGenerator = valueGenerator;
        this.ruleRemark = ruleRemark;
    }

    public Integer getMinSize() {
        return this.minSize;
    }

    public Integer getMaxSize() {
        return this.maxSize;
    }

    public Supplier<Map<Object, Object>> getMapInstanceSupplier() {
        return this.mapInstanceSupplier;
    }

    public Generator<Object> getKeyGenerator() {
        return this.keyGenerator;
    }

    public Generator<Object> getValueGenerator() {
        return this.valueGenerator;
    }

    public RuleRemark getRuleRemark() {
        return this.ruleRemark;
    }
}

