/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator;

import java.util.function.Supplier;
import org.laoruga.dtogenerator.DtoGeneratorBuildersTree;
import org.laoruga.dtogenerator.DtoInstanceSupplier;
import org.laoruga.dtogenerator.api.generators.Generator;
import org.laoruga.dtogenerator.constants.Boundary;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.generator.config.dto.NestedConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NestedDtoGenerator
implements Generator<Object> {
    private static final Logger log = LoggerFactory.getLogger(NestedDtoGenerator.class);
    private final DtoGeneratorBuildersTree.Node dtoGeneratorBuilderTreeNode;

    public NestedDtoGenerator(NestedConfig config) {
        this.dtoGeneratorBuilderTreeNode = config.getDtoGeneratorBuilderTreeNode();
        try {
            Boundary boundaryValue = (Boundary)config.getRuleRemark();
            if (boundaryValue != Boundary.NOT_DEFINED) {
                this.dtoGeneratorBuilderTreeNode.getDtoGeneratorBuilder().setBoundary(boundaryValue);
            }
        }
        catch (DtoGeneratorException e) {
            if (e.getMessage().contains("Attempt to overwrite remark")) {
                log.debug("Rule remark wasn't overridden for NestedDtoGenerator, because it defined in root DtoGeneratorBuilder.");
            }
            throw e;
        }
    }

    @Override
    public Object generate() {
        Supplier<?> dtoInstanceSupplier = this.dtoGeneratorBuilderTreeNode.getFieldGeneratorsProvider().getDtoInstanceSupplier();
        if (dtoInstanceSupplier instanceof DtoInstanceSupplier) {
            ((DtoInstanceSupplier)dtoInstanceSupplier).updateInstance();
        }
        return dtoInstanceSupplier.get();
    }

    public NestedDtoGenerator(DtoGeneratorBuildersTree.Node dtoGeneratorBuilderTreeNode) {
        this.dtoGeneratorBuilderTreeNode = dtoGeneratorBuilderTreeNode;
    }

    public DtoGeneratorBuildersTree.Node getDtoGeneratorBuilderTreeNode() {
        return this.dtoGeneratorBuilderTreeNode;
    }
}

