/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.laoruga.dtogenerator.api.RuleRemark;
import org.laoruga.dtogenerator.api.generators.Generator;
import org.laoruga.dtogenerator.constants.Boundary;
import org.laoruga.dtogenerator.generator.config.dto.IntegralConfig;
import org.laoruga.dtogenerator.util.RandomUtils;

public class NumberGenerator
implements Generator<Number> {
    private final Number maxValue;
    private final Number minValue;
    private final boolean isAtomic;
    private final RuleRemark ruleRemark;

    public NumberGenerator(IntegralConfig configDto) {
        this.maxValue = configDto.getMaxValue();
        this.minValue = configDto.getMinValue();
        this.isAtomic = configDto.isAtomic();
        this.ruleRemark = configDto.getRuleRemark();
    }

    @Override
    public Number generate() {
        Number result;
        switch ((Boundary)this.ruleRemark) {
            case MIN_VALUE: {
                result = this.minValue;
                break;
            }
            case MAX_VALUE: {
                result = this.maxValue;
                break;
            }
            case NULL_VALUE: {
                return null;
            }
            case RANDOM_VALUE: 
            case NOT_DEFINED: {
                result = RandomUtils.nextNumber(this.minValue, this.maxValue);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value " + this.ruleRemark);
            }
        }
        if (this.isAtomic) {
            if (result.getClass() == Long.class) {
                return new AtomicLong((Long)result);
            }
            if (result.getClass() == Integer.class) {
                return new AtomicInteger((Integer)result);
            }
            throw new IllegalStateException("Unexpected type: '" + result.getClass() + "'");
        }
        return result;
    }

    public NumberGenerator(Number maxValue, Number minValue, boolean isAtomic, RuleRemark ruleRemark) {
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.isAtomic = isAtomic;
        this.ruleRemark = ruleRemark;
    }
}

