/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator;

import com.mifmif.common.regex.Generex;
import java.util.Objects;
import org.laoruga.dtogenerator.api.RuleRemark;
import org.laoruga.dtogenerator.api.generators.Generator;
import org.laoruga.dtogenerator.constants.Boundary;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.generator.config.dto.StringConfig;
import org.laoruga.dtogenerator.util.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringGenerator
implements Generator<String> {
    private static final Logger log = LoggerFactory.getLogger(StringGenerator.class);
    private final int maxLength;
    private final int minLength;
    private final char[] chars;
    private final String[] words;
    private final RuleRemark ruleRemark;
    private final String regexp;

    public StringGenerator(StringConfig config) {
        this.maxLength = config.getMaxLength();
        this.minLength = config.getMinLength();
        this.chars = config.getChars().toCharArray();
        this.words = config.getWords();
        this.ruleRemark = Objects.requireNonNull(config.getRuleRemark(), "Rule remark not set.");
        this.regexp = config.getRegexp();
        if (this.words.length > 0) {
            for (String word : this.words) {
                if (word.length() < this.minLength) {
                    throw new DtoGeneratorException("Length of the word ''" + word + "' less then required: '" + this.minLength + "'");
                }
                if (word.length() <= this.maxLength) continue;
                throw new DtoGeneratorException("Length of the word ''" + word + "' greater then required: '" + this.maxLength + "'");
            }
        }
    }

    @Override
    public String generate() {
        int length;
        switch ((Boundary)this.ruleRemark) {
            case MIN_VALUE: {
                length = this.minLength;
                break;
            }
            case MAX_VALUE: {
                length = this.maxLength;
                break;
            }
            case NULL_VALUE: {
                return null;
            }
            case RANDOM_VALUE: 
            case NOT_DEFINED: {
                length = RandomUtils.nextInt(this.minLength, this.maxLength);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value " + this.ruleRemark);
            }
        }
        if (this.words.length != 0) {
            return this.getRandomWord();
        }
        if (this.regexp != null && !this.regexp.isEmpty()) {
            return this.generateStringByRegexp();
        }
        return this.generateString(length);
    }

    private String generateString(int length) {
        return RandomUtils.nextString(this.chars, length);
    }

    private String generateStringByRegexp() {
        String generatedString = new Generex(this.regexp).random(this.minLength, this.maxLength);
        int generatedStringLength = generatedString.length();
        if (generatedStringLength < this.minLength) {
            throw new DtoGeneratorException("Length of string generated by regexp is less then required: '" + this.minLength + "' Generated string: " + generatedString);
        }
        if (generatedStringLength > this.maxLength) {
            throw new DtoGeneratorException("Length of string generated by regexp is greater then required: '" + this.maxLength + "' Generated string: " + generatedString);
        }
        return generatedString;
    }

    private String getRandomWord() {
        return RandomUtils.getRandomItem(this.words);
    }

    public StringGenerator(int maxLength, int minLength, char[] chars, String[] words, RuleRemark ruleRemark, String regexp) {
        this.maxLength = maxLength;
        this.minLength = minLength;
        this.chars = chars;
        this.words = words;
        this.ruleRemark = ruleRemark;
        this.regexp = regexp;
    }
}

