/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator.config;

import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.laoruga.dtogenerator.RemarksHolder;
import org.laoruga.dtogenerator.api.RuleRemark;
import org.laoruga.dtogenerator.api.generators.Generator;
import org.laoruga.dtogenerator.config.ConfigurationHolder;
import org.laoruga.dtogenerator.config.dto.DtoGeneratorStaticConfig;
import org.laoruga.dtogenerator.config.types.TypeGeneratorsConfigLazy;
import org.laoruga.dtogenerator.constants.Boundary;
import org.laoruga.dtogenerator.constants.RulesInstance;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.generator.config.dto.ArrayConfig;
import org.laoruga.dtogenerator.generator.config.dto.BooleanConfig;
import org.laoruga.dtogenerator.generator.config.dto.CollectionConfig;
import org.laoruga.dtogenerator.generator.config.dto.ConfigDto;
import org.laoruga.dtogenerator.generator.config.dto.DecimalConfig;
import org.laoruga.dtogenerator.generator.config.dto.EnumConfig;
import org.laoruga.dtogenerator.generator.config.dto.IntegralConfig;
import org.laoruga.dtogenerator.generator.config.dto.MapConfig;
import org.laoruga.dtogenerator.generator.config.dto.datetime.DateTimeConfig;
import org.laoruga.dtogenerator.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorConfigurator {
    private static final Logger log = LoggerFactory.getLogger(GeneratorConfigurator.class);
    private final ConfigurationHolder configuration;
    RemarksHolder remarksHolder;
    public static final Consumer<ConfigDto> EMPTY_SPECIFIC_CONFIG = configDto -> log.debug("Specific config is absent.");

    protected GeneratorConfigurator(ConfigurationHolder configuration, RemarksHolder remarksHolder) {
        this.configuration = configuration;
        this.remarksHolder = remarksHolder;
    }

    public RuleRemark getRuleRemarkOrNull(String fieldName) {
        return this.remarksHolder.getBoundaryOrNull(fieldName);
    }

    protected ConfigDto mergeGeneratorConfigurations(Supplier<ConfigDto> newConfigInstanceSupplier, Class<?> fieldType, String fieldName) {
        return this.mergeGeneratorConfigurations(newConfigInstanceSupplier, EMPTY_SPECIFIC_CONFIG, fieldType, fieldName);
    }

    public ConfigDto mergeGeneratorConfigurations(Supplier<ConfigDto> newConfigInstanceSupplier, Consumer<ConfigDto> specificConfiguration, Class<?> fieldType, String fieldName) {
        ConfigDto config = newConfigInstanceSupplier.get();
        ConfigDto staticConfig = ((TypeGeneratorsConfigLazy)DtoGeneratorStaticConfig.getInstance().getTypeGeneratorsConfig()).getOrNull(fieldType);
        ConfigDto instanceConfig = this.getConfiguration().getTypeGeneratorsConfig().getOrNull(fieldType);
        ConfigDto fieldConfig = this.getConfiguration().getTypeGeneratorsConfigForField().getOrNull(fieldName, config.getClass());
        if (staticConfig != null) {
            config.merge(staticConfig);
        }
        if (instanceConfig != null) {
            config.merge(instanceConfig);
        }
        if (fieldConfig != null) {
            config.merge(fieldConfig);
        }
        if (this.getRuleRemarkOrNull(fieldName) != null) {
            config.setRuleRemark(this.getRuleRemarkOrNull(fieldName));
        }
        if (specificConfiguration != null) {
            specificConfiguration.accept(config);
        }
        return config;
    }

    public static Consumer<ConfigDto> getEnumGeneratorSpecificConfig(Class<?> generatedType) {
        return config -> {
            EnumConfig enumConfig = (EnumConfig)config;
            if (enumConfig.getEnumClass() == null) {
                if (generatedType.isEnum()) {
                    enumConfig.setEnumClass(generatedType);
                } else {
                    throw new DtoGeneratorException("Field type must be enum : '" + generatedType + "'");
                }
            }
        };
    }

    public static Consumer<ConfigDto> getTemporalGeneratorSpecificConfig(Class<? extends Temporal> generatedType) {
        return config -> {
            DateTimeConfig dateTimeConfig = (DateTimeConfig)config;
            dateTimeConfig.setGeneratedType(generatedType);
        };
    }

    public static Consumer<ConfigDto> getCollectionGeneratorSpecificConfig(Class<? extends Collection<?>> generatedType, Generator<?> elementGenerator) {
        return config -> {
            CollectionConfig collectionConfig = (CollectionConfig)config;
            if (collectionConfig.getCollectionInstanceSupplier() == null) {
                collectionConfig.setCollectionInstanceSupplier(() -> (Collection)ReflectionUtils.createInstance(generatedType, new Object[0]));
            }
            if (collectionConfig.getElementGenerator() == null) {
                collectionConfig.setElementGenerator(elementGenerator);
            }
        };
    }

    public static Consumer<ConfigDto> getArrayGeneratorSpecificConfig(Class<?> elementType, Generator<?> elementGenerator) {
        return config -> {
            ArrayConfig arrayConfig = (ArrayConfig)config;
            arrayConfig.setElementType(elementType);
            if (arrayConfig.getElementGenerator() == null) {
                arrayConfig.setElementGenerator(elementGenerator);
            }
        };
    }

    public static Consumer<ConfigDto> getMapGeneratorSpecificConfig(Class<? extends Map<?, ?>> generatedType, Generator<?> keyGenerator, Generator<?> valueGenerator) {
        return config -> {
            MapConfig mapConfig = (MapConfig)config;
            if (mapConfig.getMapInstanceSupplier() == null) {
                mapConfig.setMapInstanceSupplier(() -> (Map)ReflectionUtils.createInstance(generatedType, new Object[0]));
            }
            if (mapConfig.getKeyGenerator() == null) {
                mapConfig.setKeyGenerator(keyGenerator);
            }
            if (mapConfig.getValueGenerator() == null) {
                mapConfig.setValueGenerator(valueGenerator);
            }
        };
    }

    static Consumer<ConfigDto> integerGeneratorSpecificConfig(Class<?> fieldType, String fieldName) {
        return config -> {
            if (config.getRuleRemark() == Boundary.NULL_VALUE && fieldType.isPrimitive()) {
                GeneratorConfigurator.reportPrimitiveCannotBeNull(fieldName);
                config.merge(new IntegralConfig(RulesInstance.NUMBER_RULE_ZEROS, fieldType).setRuleRemark(Boundary.MIN_VALUE));
            }
        };
    }

    static Consumer<ConfigDto> decimalGeneratorSpecificConfig(Class<?> fieldType, String fieldName) {
        return config -> {
            if (config.getRuleRemark() == Boundary.NULL_VALUE && fieldType.isPrimitive()) {
                GeneratorConfigurator.reportPrimitiveCannotBeNull(fieldName);
                ((DecimalConfig)config).setMinValue(0.0).setMaxValue(0.0).setRuleRemark(Boundary.MIN_VALUE);
            }
        };
    }

    static Consumer<ConfigDto> booleanGeneratorSpecificConfig(Class<?> fieldType, String fieldName) {
        return config -> {
            if (config.getRuleRemark() == Boundary.NULL_VALUE && fieldType.isPrimitive()) {
                GeneratorConfigurator.reportPrimitiveCannotBeNull(fieldName);
                ((BooleanConfig)config).setTrueProbability(0.0).setRuleRemark(Boundary.MIN_VALUE);
            }
        };
    }

    protected static void reportPrimitiveCannotBeNull(String fieldName) {
        log.warn("Primitive field " + fieldName + " can't be null, it will be assigned to '0'");
    }

    public ConfigurationHolder getConfiguration() {
        return this.configuration;
    }

    public RemarksHolder getRemarksHolder() {
        return this.remarksHolder;
    }
}

