/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator.config;

import com.google.common.primitives.Primitives;
import java.lang.annotation.Annotation;
import java.time.temporal.Temporal;
import org.laoruga.dtogenerator.RemarksHolder;
import org.laoruga.dtogenerator.api.rules.BooleanRule;
import org.laoruga.dtogenerator.api.rules.DecimalRule;
import org.laoruga.dtogenerator.api.rules.EnumRule;
import org.laoruga.dtogenerator.api.rules.IntegralRule;
import org.laoruga.dtogenerator.api.rules.StringRule;
import org.laoruga.dtogenerator.api.rules.datetime.DateTimeRule;
import org.laoruga.dtogenerator.config.ConfigurationHolder;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.generator.config.GeneratorConfigurator;
import org.laoruga.dtogenerator.generator.config.dto.BooleanConfig;
import org.laoruga.dtogenerator.generator.config.dto.ConfigDto;
import org.laoruga.dtogenerator.generator.config.dto.DecimalConfig;
import org.laoruga.dtogenerator.generator.config.dto.EnumConfig;
import org.laoruga.dtogenerator.generator.config.dto.IntegralConfig;
import org.laoruga.dtogenerator.generator.config.dto.StringConfig;
import org.laoruga.dtogenerator.generator.config.dto.datetime.DateTimeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorConfiguratorByAnnotation
extends GeneratorConfigurator {
    private static final Logger log = LoggerFactory.getLogger(GeneratorConfiguratorByAnnotation.class);

    public GeneratorConfiguratorByAnnotation(ConfigurationHolder configuration, RemarksHolder remarksHolder) {
        super(configuration, remarksHolder);
    }

    public ConfigDto createGeneratorConfig(Annotation rules, Class<?> fieldType, String fieldName) {
        Class<? extends Annotation> rulesClass = rules.annotationType();
        try {
            if (BooleanRule.class == rulesClass) {
                return this.mergeGeneratorConfigurations(() -> new BooleanConfig((BooleanRule)rules), GeneratorConfiguratorByAnnotation.booleanGeneratorSpecificConfig(fieldType, fieldName), fieldType, fieldName);
            }
            if (StringRule.class == rulesClass) {
                return this.mergeGeneratorConfigurations(() -> new StringConfig((StringRule)rules), fieldType, fieldName);
            }
            if (DecimalRule.class == rulesClass) {
                if (Number.class.isAssignableFrom(Primitives.wrap(fieldType))) {
                    Class<?> fieldTypeNumber = fieldType;
                    return this.mergeGeneratorConfigurations(() -> new DecimalConfig((DecimalRule)rules, fieldTypeNumber), GeneratorConfiguratorByAnnotation.decimalGeneratorSpecificConfig(fieldType, fieldName), fieldType, fieldName);
                }
                throw new IllegalArgumentException("Unexpected state. Field type '" + fieldType + "' doesn't extend Number.class");
            }
            if (IntegralRule.class == rulesClass) {
                if (Number.class.isAssignableFrom(Primitives.wrap(fieldType))) {
                    Class<?> fieldTypeNumber = fieldType;
                    return this.mergeGeneratorConfigurations(() -> new IntegralConfig((IntegralRule)rules, fieldTypeNumber), GeneratorConfiguratorByAnnotation.integerGeneratorSpecificConfig(fieldType, fieldName), fieldType, fieldName);
                }
                throw new IllegalArgumentException("Unexpected state. Field type '" + fieldType + "' doesn't extend Number.class");
            }
            if (EnumRule.class == rulesClass) {
                if (Enum.class.isAssignableFrom(fieldType)) {
                    return this.mergeGeneratorConfigurations(() -> new EnumConfig((EnumRule)rules), GeneratorConfiguratorByAnnotation.getEnumGeneratorSpecificConfig(fieldType), fieldType, fieldName);
                }
                throw new IllegalArgumentException("Unexpected state. Field type '" + fieldType + "' is not Enum");
            }
            if (DateTimeRule.class == rulesClass) {
                if (Temporal.class.isAssignableFrom(fieldType)) {
                    Class<?> fieldTypeTemporal = fieldType;
                    return this.mergeGeneratorConfigurations(() -> new DateTimeConfig((DateTimeRule)rules, fieldTypeTemporal), fieldType, fieldName);
                }
                throw new IllegalArgumentException("Unexpected state. Field type '" + fieldType + "' is not Temporal");
            }
            throw new DtoGeneratorException("Unable to rules class: '" + rulesClass + "'.");
        }
        catch (Exception e) {
            throw new DtoGeneratorException("Unexpected error.", e);
        }
    }
}

