/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator.config.dto;

import org.laoruga.dtogenerator.api.RuleRemark;
import org.laoruga.dtogenerator.api.generators.Generator;
import org.laoruga.dtogenerator.api.rules.ArrayRule;
import org.laoruga.dtogenerator.generator.config.dto.ConfigDto;

public class ArrayConfig
implements ConfigDto {
    private Integer minSize;
    private Integer maxSize;
    private Class<?> elementType;
    private Generator<?> elementGenerator;
    private RuleRemark ruleRemark;

    public ArrayConfig(ArrayRule rule, Class<?> elementType) {
        this.minSize = rule.minLength();
        this.maxSize = rule.maxLength();
        this.elementType = elementType;
        this.ruleRemark = rule.boundary();
    }

    public void merge(ArrayConfig from) {
        if (from.getMinSize() != null) {
            this.minSize = from.getMinSize();
        }
        if (from.getMaxSize() != null) {
            this.maxSize = from.getMaxSize();
        }
        if (from.getElementType() != null) {
            this.elementType = from.getElementType();
        }
        if (from.getElementGenerator() != null) {
            this.elementGenerator = from.getElementGenerator();
        }
        if (from.getRuleRemark() != null) {
            this.ruleRemark = from.getRuleRemark();
        }
    }

    @Override
    public void merge(ConfigDto configDto) {
        ArrayConfig fromConfig = (ArrayConfig)configDto;
        if (fromConfig.getMinSize() != null) {
            this.minSize = fromConfig.getMinSize();
        }
        if (fromConfig.getMaxSize() != null) {
            this.maxSize = fromConfig.getMaxSize();
        }
        if (fromConfig.getElementType() != null) {
            this.elementType = fromConfig.getElementType();
        }
        if (fromConfig.getElementGenerator() != null) {
            this.elementGenerator = fromConfig.getElementGenerator();
        }
        if (fromConfig.getRuleRemark() != null) {
            this.ruleRemark = fromConfig.getRuleRemark();
        }
    }

    public static ArrayConfigBuilder builder() {
        return new ArrayConfigBuilder();
    }

    public Integer getMinSize() {
        return this.minSize;
    }

    public Integer getMaxSize() {
        return this.maxSize;
    }

    public Class<?> getElementType() {
        return this.elementType;
    }

    public Generator<?> getElementGenerator() {
        return this.elementGenerator;
    }

    @Override
    public RuleRemark getRuleRemark() {
        return this.ruleRemark;
    }

    public ArrayConfig setMinSize(Integer minSize) {
        this.minSize = minSize;
        return this;
    }

    public ArrayConfig setMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public ArrayConfig setElementType(Class<?> elementType) {
        this.elementType = elementType;
        return this;
    }

    public ArrayConfig setElementGenerator(Generator<?> elementGenerator) {
        this.elementGenerator = elementGenerator;
        return this;
    }

    @Override
    public ArrayConfig setRuleRemark(RuleRemark ruleRemark) {
        this.ruleRemark = ruleRemark;
        return this;
    }

    public ArrayConfig() {
    }

    public ArrayConfig(Integer minSize, Integer maxSize, Class<?> elementType, Generator<?> elementGenerator, RuleRemark ruleRemark) {
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.elementType = elementType;
        this.elementGenerator = elementGenerator;
        this.ruleRemark = ruleRemark;
    }

    public static class ArrayConfigBuilder {
        private Integer minSize;
        private Integer maxSize;
        private Class<?> elementType;
        private Generator<?> elementGenerator;
        private RuleRemark ruleRemark;

        ArrayConfigBuilder() {
        }

        public ArrayConfigBuilder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public ArrayConfigBuilder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public ArrayConfigBuilder elementType(Class<?> elementType) {
            this.elementType = elementType;
            return this;
        }

        public ArrayConfigBuilder elementGenerator(Generator<?> elementGenerator) {
            this.elementGenerator = elementGenerator;
            return this;
        }

        public ArrayConfigBuilder ruleRemark(RuleRemark ruleRemark) {
            this.ruleRemark = ruleRemark;
            return this;
        }

        public ArrayConfig build() {
            return new ArrayConfig(this.minSize, this.maxSize, this.elementType, this.elementGenerator, this.ruleRemark);
        }

        public String toString() {
            return "ArrayConfig.ArrayConfigBuilder(minSize=" + this.minSize + ", maxSize=" + this.maxSize + ", elementType=" + this.elementType + ", elementGenerator=" + this.elementGenerator + ", ruleRemark=" + this.ruleRemark + ")";
        }
    }
}

