/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator.config.dto;

import org.laoruga.dtogenerator.api.RuleRemark;
import org.laoruga.dtogenerator.api.rules.BooleanRule;
import org.laoruga.dtogenerator.generator.config.dto.ConfigDto;

public class BooleanConfig
implements ConfigDto {
    private Double trueProbability;
    private RuleRemark ruleRemark;

    public BooleanConfig(BooleanRule rule) {
        this.trueProbability = rule.trueProbability();
        this.ruleRemark = rule.boundary();
    }

    @Override
    public void merge(ConfigDto from) {
        BooleanConfig configDto = (BooleanConfig)from;
        if (configDto.getTrueProbability() != null) {
            this.trueProbability = configDto.getTrueProbability();
        }
        if (configDto.getRuleRemark() != null) {
            this.ruleRemark = configDto.getRuleRemark();
        }
    }

    public static BooleanConfigBuilder builder() {
        return new BooleanConfigBuilder();
    }

    public Double getTrueProbability() {
        return this.trueProbability;
    }

    @Override
    public RuleRemark getRuleRemark() {
        return this.ruleRemark;
    }

    public BooleanConfig setTrueProbability(Double trueProbability) {
        this.trueProbability = trueProbability;
        return this;
    }

    @Override
    public BooleanConfig setRuleRemark(RuleRemark ruleRemark) {
        this.ruleRemark = ruleRemark;
        return this;
    }

    public BooleanConfig() {
    }

    public BooleanConfig(Double trueProbability, RuleRemark ruleRemark) {
        this.trueProbability = trueProbability;
        this.ruleRemark = ruleRemark;
    }

    public static class BooleanConfigBuilder {
        private Double trueProbability;
        private RuleRemark ruleRemark;

        BooleanConfigBuilder() {
        }

        public BooleanConfigBuilder trueProbability(Double trueProbability) {
            this.trueProbability = trueProbability;
            return this;
        }

        public BooleanConfigBuilder ruleRemark(RuleRemark ruleRemark) {
            this.ruleRemark = ruleRemark;
            return this;
        }

        public BooleanConfig build() {
            return new BooleanConfig(this.trueProbability, this.ruleRemark);
        }

        public String toString() {
            return "BooleanConfig.BooleanConfigBuilder(trueProbability=" + this.trueProbability + ", ruleRemark=" + this.ruleRemark + ")";
        }
    }
}

