/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator.config.dto;

import java.util.function.Supplier;
import org.laoruga.dtogenerator.api.RuleRemark;
import org.laoruga.dtogenerator.api.generators.Generator;
import org.laoruga.dtogenerator.api.rules.CollectionRule;
import org.laoruga.dtogenerator.generator.config.dto.ConfigDto;
import org.laoruga.dtogenerator.util.ReflectionUtils;
import org.laoruga.dtogenerator.util.dummy.DummyCollectionClass;

public class CollectionConfig
implements ConfigDto {
    private Integer minSize;
    private Integer maxSize;
    private Supplier<?> collectionInstanceSupplier;
    private Generator<?> elementGenerator;
    private RuleRemark ruleRemark;

    public CollectionConfig(CollectionRule rule) {
        this.minSize = rule.minSize();
        this.maxSize = rule.maxSize();
        this.collectionInstanceSupplier = rule.collectionClass() != DummyCollectionClass.class ? () -> ReflectionUtils.createInstance(rule.collectionClass(), new Object[0]) : null;
        this.ruleRemark = rule.boundary();
    }

    public void merge(CollectionConfig from) {
        if (from.getMinSize() != null) {
            this.minSize = from.getMinSize();
        }
        if (from.getMaxSize() != null) {
            this.maxSize = from.getMaxSize();
        }
        if (from.getCollectionInstanceSupplier() != null) {
            this.collectionInstanceSupplier = from.getCollectionInstanceSupplier();
        }
        if (from.getElementGenerator() != null) {
            this.elementGenerator = from.getElementGenerator();
        }
        if (from.getRuleRemark() != null) {
            this.ruleRemark = from.getRuleRemark();
        }
    }

    @Override
    public void merge(ConfigDto configDto) {
        CollectionConfig fromConfig = (CollectionConfig)configDto;
        if (fromConfig.getMinSize() != null) {
            this.minSize = fromConfig.getMinSize();
        }
        if (fromConfig.getMaxSize() != null) {
            this.maxSize = fromConfig.getMaxSize();
        }
        if (fromConfig.getCollectionInstanceSupplier() != null) {
            this.collectionInstanceSupplier = fromConfig.getCollectionInstanceSupplier();
        }
        if (fromConfig.getElementGenerator() != null) {
            this.elementGenerator = fromConfig.getElementGenerator();
        }
        if (fromConfig.getRuleRemark() != null) {
            this.ruleRemark = fromConfig.getRuleRemark();
        }
    }

    public static CollectionConfigBuilder builder() {
        return new CollectionConfigBuilder();
    }

    public Integer getMinSize() {
        return this.minSize;
    }

    public Integer getMaxSize() {
        return this.maxSize;
    }

    public Supplier<?> getCollectionInstanceSupplier() {
        return this.collectionInstanceSupplier;
    }

    public Generator<?> getElementGenerator() {
        return this.elementGenerator;
    }

    @Override
    public RuleRemark getRuleRemark() {
        return this.ruleRemark;
    }

    public CollectionConfig setMinSize(Integer minSize) {
        this.minSize = minSize;
        return this;
    }

    public CollectionConfig setMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public CollectionConfig setCollectionInstanceSupplier(Supplier<?> collectionInstanceSupplier) {
        this.collectionInstanceSupplier = collectionInstanceSupplier;
        return this;
    }

    public CollectionConfig setElementGenerator(Generator<?> elementGenerator) {
        this.elementGenerator = elementGenerator;
        return this;
    }

    @Override
    public CollectionConfig setRuleRemark(RuleRemark ruleRemark) {
        this.ruleRemark = ruleRemark;
        return this;
    }

    public CollectionConfig() {
    }

    public CollectionConfig(Integer minSize, Integer maxSize, Supplier<?> collectionInstanceSupplier, Generator<?> elementGenerator, RuleRemark ruleRemark) {
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.collectionInstanceSupplier = collectionInstanceSupplier;
        this.elementGenerator = elementGenerator;
        this.ruleRemark = ruleRemark;
    }

    public static class CollectionConfigBuilder {
        private Integer minSize;
        private Integer maxSize;
        private Supplier<?> collectionInstanceSupplier;
        private Generator<?> elementGenerator;
        private RuleRemark ruleRemark;

        CollectionConfigBuilder() {
        }

        public CollectionConfigBuilder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public CollectionConfigBuilder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public CollectionConfigBuilder collectionInstanceSupplier(Supplier<?> collectionInstanceSupplier) {
            this.collectionInstanceSupplier = collectionInstanceSupplier;
            return this;
        }

        public CollectionConfigBuilder elementGenerator(Generator<?> elementGenerator) {
            this.elementGenerator = elementGenerator;
            return this;
        }

        public CollectionConfigBuilder ruleRemark(RuleRemark ruleRemark) {
            this.ruleRemark = ruleRemark;
            return this;
        }

        public CollectionConfig build() {
            return new CollectionConfig(this.minSize, this.maxSize, this.collectionInstanceSupplier, this.elementGenerator, this.ruleRemark);
        }

        public String toString() {
            return "CollectionConfig.CollectionConfigBuilder(minSize=" + this.minSize + ", maxSize=" + this.maxSize + ", collectionInstanceSupplier=" + this.collectionInstanceSupplier + ", elementGenerator=" + this.elementGenerator + ", ruleRemark=" + this.ruleRemark + ")";
        }
    }
}

