/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator.config.dto;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.laoruga.dtogenerator.api.RuleRemark;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.generator.config.dto.ConfigDto;
import org.laoruga.dtogenerator.generator.config.dto.DecimalConfig;

public class DecimalCommonConfig
implements ConfigDto {
    private RuleRemark ruleRemark;
    private final Map<Class<?>, DecimalConfig> map = new HashMap();

    public DecimalCommonConfig setMaxDoubleValue(double value) {
        return this.setMaxValue(Double.class, value);
    }

    public DecimalCommonConfig setMinDoubleValue(double value) {
        return this.setMinValue(Double.class, value);
    }

    public DecimalCommonConfig setRuleRemarkDouble(RuleRemark value) {
        return this.setRuleRemark(Double.class, value);
    }

    public DecimalCommonConfig setPrecisionDouble(int value) {
        return this.setPrecision(Double.class, value);
    }

    public DecimalCommonConfig setMaxFloatValue(float value) {
        return this.setMaxValue(Float.class, Float.valueOf(value));
    }

    public DecimalCommonConfig setMinFloatValue(float value) {
        return this.setMinValue(Float.class, Float.valueOf(value));
    }

    public DecimalCommonConfig setRuleRemarkFloat(RuleRemark value) {
        return this.setRuleRemark(Float.class, value);
    }

    public DecimalCommonConfig setPrecisionFloat(int value) {
        return this.setPrecision(Float.class, value);
    }

    public DecimalCommonConfig setMaxBigDecimalValue(BigDecimal value) {
        return this.setMaxValue(BigDecimal.class, value);
    }

    public DecimalCommonConfig setMinBigDecimalValue(BigDecimal value) {
        return this.setMinValue(BigDecimal.class, value);
    }

    public DecimalCommonConfig setMaxBigDecimalValue(String value) {
        try {
            return this.setMaxBigDecimalValue(new BigDecimal(value));
        }
        catch (NumberFormatException e) {
            throw new DtoGeneratorException("Invalid big integer number: '" + value + "'", e);
        }
    }

    public DecimalCommonConfig setMinBigDecimalValue(String value) {
        try {
            return this.setMinBigDecimalValue(new BigDecimal(value));
        }
        catch (NumberFormatException e) {
            throw new DtoGeneratorException("Invalid big integer number: '" + value + "'", e);
        }
    }

    public DecimalCommonConfig setRuleRemarkBigDecimal(RuleRemark value) {
        return this.setRuleRemark(BigDecimal.class, value);
    }

    public DecimalCommonConfig setPrecisionBigDecimal(int value) {
        return this.setPrecision(BigDecimal.class, value);
    }

    private DecimalCommonConfig setMaxValue(Class<?> type, Number maxValue) {
        this.map.putIfAbsent(type, new DecimalConfig());
        this.map.get(type).setMaxValue(maxValue);
        return this;
    }

    private DecimalCommonConfig setMinValue(Class<?> type, Number minValue) {
        this.map.putIfAbsent(type, new DecimalConfig());
        this.map.get(type).setMinValue(minValue);
        return this;
    }

    private DecimalCommonConfig setRuleRemark(Class<?> type, RuleRemark ruleRemark) {
        this.map.putIfAbsent(type, new DecimalConfig());
        this.map.get(type).setRuleRemark(ruleRemark);
        return this;
    }

    private DecimalCommonConfig setPrecision(Class<?> type, int precision) {
        this.map.putIfAbsent(type, new DecimalConfig());
        this.map.get(type).setPrecision(precision);
        return this;
    }

    DecimalConfig getConfigOrNull(Class<? extends Number> generateType) {
        return this.map.get(generateType);
    }

    @Override
    public void merge(ConfigDto configDto) {
        throw new NotImplementedException("Not supposed to be in use.");
    }

    @Override
    public RuleRemark getRuleRemark() {
        return this.ruleRemark;
    }

    @Override
    public DecimalCommonConfig setRuleRemark(RuleRemark ruleRemark) {
        this.ruleRemark = ruleRemark;
        return this;
    }
}

