/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator.config.dto;

import com.google.common.primitives.Primitives;
import java.math.BigDecimal;
import org.laoruga.dtogenerator.api.RuleRemark;
import org.laoruga.dtogenerator.api.rules.DecimalRule;
import org.laoruga.dtogenerator.generator.config.dto.ConfigDto;
import org.laoruga.dtogenerator.generator.config.dto.DecimalCommonConfig;

public class DecimalConfig
implements ConfigDto {
    private Number maxValue;
    private Number minValue;
    private Integer precision;
    private RuleRemark ruleRemark;
    private Class<? extends Number> fieldType;

    public DecimalConfig(DecimalRule rule, Class<? extends Number> fieldType) {
        this.fieldType = fieldType = Primitives.wrap(fieldType);
        this.ruleRemark = rule.boundary();
        this.precision = rule.precision();
        if (fieldType == Double.class) {
            this.maxValue = rule.maxDouble();
            this.minValue = rule.minDouble();
        } else if (fieldType == Float.class) {
            this.maxValue = Float.valueOf(rule.maxFloat());
            this.minValue = Float.valueOf(rule.minFloat());
        } else if (fieldType == BigDecimal.class) {
            this.maxValue = new BigDecimal(rule.maxBigDecimal());
            this.minValue = new BigDecimal(rule.minBigDecimal());
        } else {
            throw new IllegalStateException("Unexpected field type: '" + fieldType + "'");
        }
    }

    @Override
    public void merge(ConfigDto configDto) {
        DecimalConfig configFrom;
        boolean commonConfig = configDto.getClass() == DecimalCommonConfig.class;
        DecimalConfig decimalConfig = configFrom = commonConfig ? ((DecimalCommonConfig)configDto).getConfigOrNull(this.fieldType) : (DecimalConfig)configDto;
        if (commonConfig && configDto.getRuleRemark() != null) {
            this.ruleRemark = configDto.getRuleRemark();
        }
        if (configFrom != null) {
            if (configFrom.getMaxValue() != null) {
                this.maxValue = configFrom.getMaxValue();
            }
            if (configFrom.getMinValue() != null) {
                this.minValue = configFrom.getMinValue();
            }
            if (configFrom.getPrecision() != null) {
                this.precision = configFrom.getPrecision();
            }
            if (configFrom.getRuleRemark() != null) {
                this.ruleRemark = configFrom.getRuleRemark();
            }
        }
    }

    public static DecimalConfigBuilder builder() {
        return new DecimalConfigBuilder();
    }

    public Number getMaxValue() {
        return this.maxValue;
    }

    public Number getMinValue() {
        return this.minValue;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    @Override
    public RuleRemark getRuleRemark() {
        return this.ruleRemark;
    }

    public Class<? extends Number> getFieldType() {
        return this.fieldType;
    }

    public DecimalConfig setMaxValue(Number maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    public DecimalConfig setMinValue(Number minValue) {
        this.minValue = minValue;
        return this;
    }

    public DecimalConfig setPrecision(Integer precision) {
        this.precision = precision;
        return this;
    }

    @Override
    public DecimalConfig setRuleRemark(RuleRemark ruleRemark) {
        this.ruleRemark = ruleRemark;
        return this;
    }

    public DecimalConfig setFieldType(Class<? extends Number> fieldType) {
        this.fieldType = fieldType;
        return this;
    }

    public DecimalConfig(Number maxValue, Number minValue, Integer precision, RuleRemark ruleRemark, Class<? extends Number> fieldType) {
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.precision = precision;
        this.ruleRemark = ruleRemark;
        this.fieldType = fieldType;
    }

    public DecimalConfig() {
    }

    public static class DecimalConfigBuilder {
        private Number maxValue;
        private Number minValue;
        private Integer precision;
        private RuleRemark ruleRemark;
        private Class<? extends Number> fieldType;

        public DecimalConfigBuilder maxValue(Double maxValue) {
            this.check(maxValue, this.minValue);
            this.maxValue = maxValue;
            return this;
        }

        public DecimalConfigBuilder minValue(Double minValue) {
            this.check(minValue, this.maxValue);
            this.minValue = minValue;
            return this;
        }

        public DecimalConfigBuilder maxValue(Float maxValue) {
            this.check(maxValue, this.minValue);
            this.maxValue = maxValue;
            return this;
        }

        public DecimalConfigBuilder minValue(Float minValue) {
            this.check(minValue, this.maxValue);
            this.minValue = minValue;
            return this;
        }

        public DecimalConfigBuilder maxValue(BigDecimal maxValue) {
            this.check(maxValue, this.minValue);
            this.maxValue = maxValue;
            return this;
        }

        public DecimalConfigBuilder minValue(BigDecimal minValue) {
            this.check(minValue, this.maxValue);
            this.minValue = minValue;
            return this;
        }

        private void check(Number valueToSet, Number another) {
            if (another != null && another.getClass() != valueToSet.getClass()) {
                throw new IllegalArgumentException("Wrong bound type: '" + valueToSet + "'. Bound with type '" + another + "' expexted.");
            }
        }

        DecimalConfigBuilder() {
        }

        public DecimalConfigBuilder precision(Integer precision) {
            this.precision = precision;
            return this;
        }

        public DecimalConfigBuilder ruleRemark(RuleRemark ruleRemark) {
            this.ruleRemark = ruleRemark;
            return this;
        }

        public DecimalConfigBuilder fieldType(Class<? extends Number> fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        public DecimalConfig build() {
            return new DecimalConfig(this.maxValue, this.minValue, this.precision, this.ruleRemark, this.fieldType);
        }

        public String toString() {
            return "DecimalConfig.DecimalConfigBuilder(maxValue=" + this.maxValue + ", minValue=" + this.minValue + ", precision=" + this.precision + ", ruleRemark=" + this.ruleRemark + ", fieldType=" + this.fieldType + ")";
        }
    }
}

