/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator.config.dto;

import java.util.Arrays;
import org.laoruga.dtogenerator.api.RuleRemark;
import org.laoruga.dtogenerator.api.rules.EnumRule;
import org.laoruga.dtogenerator.generator.config.dto.ConfigDto;

public class EnumConfig
implements ConfigDto {
    private String[] possibleEnumNames;
    private Class<? extends Enum<?>> enumClass;
    private RuleRemark ruleRemark;

    public EnumConfig(EnumRule enumRule) {
        this.possibleEnumNames = enumRule.possibleEnumNames();
        this.ruleRemark = enumRule.boundary();
    }

    @Override
    public void merge(ConfigDto from) {
        EnumConfig configDto = (EnumConfig)from;
        if (configDto.getPossibleEnumNames() != null) {
            this.possibleEnumNames = configDto.getPossibleEnumNames();
        }
        if (configDto.getEnumClass() != null) {
            this.enumClass = configDto.getEnumClass();
        }
        if (configDto.getRuleRemark() != null) {
            this.ruleRemark = configDto.getRuleRemark();
        }
    }

    public static EnumConfigBuilder builder() {
        return new EnumConfigBuilder();
    }

    public String[] getPossibleEnumNames() {
        return this.possibleEnumNames;
    }

    public Class<? extends Enum<?>> getEnumClass() {
        return this.enumClass;
    }

    @Override
    public RuleRemark getRuleRemark() {
        return this.ruleRemark;
    }

    public EnumConfig setPossibleEnumNames(String[] possibleEnumNames) {
        this.possibleEnumNames = possibleEnumNames;
        return this;
    }

    public EnumConfig setEnumClass(Class<? extends Enum<?>> enumClass) {
        this.enumClass = enumClass;
        return this;
    }

    @Override
    public EnumConfig setRuleRemark(RuleRemark ruleRemark) {
        this.ruleRemark = ruleRemark;
        return this;
    }

    public EnumConfig() {
    }

    public EnumConfig(String[] possibleEnumNames, Class<? extends Enum<?>> enumClass, RuleRemark ruleRemark) {
        this.possibleEnumNames = possibleEnumNames;
        this.enumClass = enumClass;
        this.ruleRemark = ruleRemark;
    }

    public static class EnumConfigBuilder {
        private String[] possibleEnumNames;
        private Class<? extends Enum<?>> enumClass;
        private RuleRemark ruleRemark;

        EnumConfigBuilder() {
        }

        public EnumConfigBuilder possibleEnumNames(String[] possibleEnumNames) {
            this.possibleEnumNames = possibleEnumNames;
            return this;
        }

        public EnumConfigBuilder enumClass(Class<? extends Enum<?>> enumClass) {
            this.enumClass = enumClass;
            return this;
        }

        public EnumConfigBuilder ruleRemark(RuleRemark ruleRemark) {
            this.ruleRemark = ruleRemark;
            return this;
        }

        public EnumConfig build() {
            return new EnumConfig(this.possibleEnumNames, this.enumClass, this.ruleRemark);
        }

        public String toString() {
            return "EnumConfig.EnumConfigBuilder(possibleEnumNames=" + Arrays.deepToString(this.possibleEnumNames) + ", enumClass=" + this.enumClass + ", ruleRemark=" + this.ruleRemark + ")";
        }
    }
}

