/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator.config.dto;

import com.google.common.primitives.Primitives;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.laoruga.dtogenerator.api.RuleRemark;
import org.laoruga.dtogenerator.api.rules.IntegralRule;
import org.laoruga.dtogenerator.generator.config.dto.ConfigDto;
import org.laoruga.dtogenerator.generator.config.dto.IntegralConfigCommonConfig;

public class IntegralConfig
implements ConfigDto {
    private Number maxValue;
    private Number minValue;
    private Class<? extends Number> fieldType;
    private boolean isAtomic;
    private RuleRemark ruleRemark;

    public IntegralConfig(IntegralRule rules, Class<? extends Number> fieldType) {
        fieldType = Primitives.wrap(fieldType);
        this.isAtomic = fieldType == AtomicInteger.class || fieldType == AtomicLong.class;
        this.fieldType = fieldType;
        this.ruleRemark = rules.boundary();
        if (fieldType == Integer.class || fieldType == AtomicInteger.class) {
            this.minValue = rules.minInt();
            this.maxValue = rules.maxInt();
        } else if (fieldType == Long.class || fieldType == AtomicLong.class) {
            this.minValue = rules.minLong();
            this.maxValue = rules.maxLong();
        } else if (fieldType == Short.class) {
            this.minValue = rules.minShort();
            this.maxValue = rules.maxShort();
        } else if (fieldType == Byte.class) {
            this.minValue = rules.minByte();
            this.maxValue = rules.maxByte();
        } else if (fieldType == BigInteger.class) {
            this.minValue = new BigInteger(rules.minBigInt());
            this.maxValue = new BigInteger(rules.maxBigInt());
        } else {
            throw new IllegalStateException("Unexpected field type: '" + fieldType + "'");
        }
    }

    public Number getMaxValue() {
        return this.maxValue;
    }

    public Number getMinValue() {
        return this.minValue;
    }

    @Override
    public void merge(ConfigDto configDto) {
        IntegralConfig configFrom;
        boolean commonConfig = configDto.getClass() == IntegralConfigCommonConfig.class;
        IntegralConfig integralConfig = configFrom = commonConfig ? ((IntegralConfigCommonConfig)configDto).getConfigOrNull(this.fieldType) : (IntegralConfig)configDto;
        if (commonConfig && configDto.getRuleRemark() != null) {
            this.ruleRemark = configDto.getRuleRemark();
        }
        if (configFrom != null) {
            if (configFrom.getMaxValue() != null) {
                this.maxValue = configFrom.getMaxValue();
            }
            if (configFrom.getMinValue() != null) {
                this.minValue = configFrom.getMinValue();
            }
            if (configFrom.getRuleRemark() != null) {
                this.ruleRemark = configFrom.getRuleRemark();
            }
        }
    }

    public static IntegralConfigBuilder builder() {
        return new IntegralConfigBuilder();
    }

    public boolean isAtomic() {
        return this.isAtomic;
    }

    @Override
    public RuleRemark getRuleRemark() {
        return this.ruleRemark;
    }

    public IntegralConfig setMaxValue(Number maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    public IntegralConfig setMinValue(Number minValue) {
        this.minValue = minValue;
        return this;
    }

    public IntegralConfig setAtomic(boolean isAtomic) {
        this.isAtomic = isAtomic;
        return this;
    }

    @Override
    public IntegralConfig setRuleRemark(RuleRemark ruleRemark) {
        this.ruleRemark = ruleRemark;
        return this;
    }

    public IntegralConfig(Number maxValue, Number minValue, Class<? extends Number> fieldType, boolean isAtomic, RuleRemark ruleRemark) {
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.fieldType = fieldType;
        this.isAtomic = isAtomic;
        this.ruleRemark = ruleRemark;
    }

    public IntegralConfig() {
    }

    private Class<? extends Number> getFieldType() {
        return this.fieldType;
    }

    private IntegralConfig setFieldType(Class<? extends Number> fieldType) {
        this.fieldType = fieldType;
        return this;
    }

    public static class IntegralConfigBuilder {
        private Number maxValue;
        private Number minValue;
        private Class<? extends Number> fieldType;
        private boolean isAtomic;
        private RuleRemark ruleRemark;

        public IntegralConfigBuilder maxValue(Integer maxValue) {
            this.check(maxValue, this.minValue);
            this.maxValue = maxValue;
            return this;
        }

        public IntegralConfigBuilder minValue(Integer minValue) {
            this.check(minValue, this.maxValue);
            this.minValue = minValue;
            return this;
        }

        public IntegralConfigBuilder maxValue(Long maxValue) {
            this.check(maxValue, this.minValue);
            this.maxValue = maxValue;
            return this;
        }

        public IntegralConfigBuilder minValue(Long minValue) {
            this.check(minValue, this.maxValue);
            this.minValue = minValue;
            return this;
        }

        public IntegralConfigBuilder maxValue(Short maxValue) {
            this.check(maxValue, this.minValue);
            this.maxValue = maxValue;
            return this;
        }

        public IntegralConfigBuilder minValue(Short minValue) {
            this.check(minValue, this.maxValue);
            this.minValue = minValue;
            return this;
        }

        public IntegralConfigBuilder maxValue(Byte maxValue) {
            this.check(maxValue, this.minValue);
            this.maxValue = maxValue;
            return this;
        }

        public IntegralConfigBuilder minValue(Byte minValue) {
            this.check(minValue, this.maxValue);
            this.minValue = minValue;
            return this;
        }

        public IntegralConfigBuilder maxValue(BigInteger maxValue) {
            this.check(maxValue, this.minValue);
            this.maxValue = maxValue;
            return this;
        }

        public IntegralConfigBuilder minValue(BigInteger minValue) {
            this.check(minValue, this.maxValue);
            this.minValue = minValue;
            return this;
        }

        private void check(Number valueToSet, Number another) {
            if (another != null && another.getClass() != valueToSet.getClass()) {
                throw new IllegalArgumentException("Wrong bound type: '" + valueToSet + "'. Bound with type '" + another + "' expexted.");
            }
        }

        IntegralConfigBuilder() {
        }

        public IntegralConfigBuilder fieldType(Class<? extends Number> fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        public IntegralConfigBuilder isAtomic(boolean isAtomic) {
            this.isAtomic = isAtomic;
            return this;
        }

        public IntegralConfigBuilder ruleRemark(RuleRemark ruleRemark) {
            this.ruleRemark = ruleRemark;
            return this;
        }

        public IntegralConfig build() {
            return new IntegralConfig(this.maxValue, this.minValue, this.fieldType, this.isAtomic, this.ruleRemark);
        }

        public String toString() {
            return "IntegralConfig.IntegralConfigBuilder(maxValue=" + this.maxValue + ", minValue=" + this.minValue + ", fieldType=" + this.fieldType + ", isAtomic=" + this.isAtomic + ", ruleRemark=" + this.ruleRemark + ")";
        }
    }
}

