/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator.config.dto;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.NotImplementedException;
import org.laoruga.dtogenerator.api.RuleRemark;
import org.laoruga.dtogenerator.generator.config.dto.ConfigDto;
import org.laoruga.dtogenerator.generator.config.dto.IntegralConfig;

public class IntegralConfigCommonConfig
implements ConfigDto {
    private final Map<Class<?>, IntegralConfig> map = new HashMap();
    private RuleRemark ruleRemark;

    public IntegralConfigCommonConfig setMaxIntValue(int value) {
        return this.setMaxValue(Integer.class, AtomicInteger.class, value);
    }

    public IntegralConfigCommonConfig setMinIntValue(int value) {
        return this.setMinValue(Integer.class, AtomicInteger.class, value);
    }

    public IntegralConfigCommonConfig setRuleRemarkInt(RuleRemark value) {
        return this.setRuleRemark(Integer.class, AtomicInteger.class, value);
    }

    public IntegralConfigCommonConfig setMaxLongValue(long value) {
        return this.setMaxValue(Long.class, AtomicLong.class, value);
    }

    public IntegralConfigCommonConfig setMinLongValue(long value) {
        return this.setMinValue(Long.class, AtomicLong.class, value);
    }

    public IntegralConfigCommonConfig setRuleRemarkLong(RuleRemark value) {
        return this.setRuleRemark(Long.class, AtomicLong.class, value);
    }

    public IntegralConfigCommonConfig setMaxShortValue(short value) {
        return this.setMaxValue(Short.class, value);
    }

    public IntegralConfigCommonConfig setMinShortValue(short value) {
        return this.setMinValue(Short.class, value);
    }

    public IntegralConfigCommonConfig setRuleRemarkShort(RuleRemark value) {
        return this.setRuleRemark(Short.class, value);
    }

    public IntegralConfigCommonConfig setMaxByteValue(byte value) {
        return this.setMaxValue(Byte.class, value);
    }

    public IntegralConfigCommonConfig setMinByteValue(byte value) {
        return this.setMinValue(Byte.class, value);
    }

    public IntegralConfigCommonConfig setRuleRemarkByte(RuleRemark value) {
        return this.setRuleRemark(Byte.class, value);
    }

    public IntegralConfigCommonConfig setMaxBigIntValue(BigInteger value) {
        return this.setMaxValue(BigInteger.class, value);
    }

    public IntegralConfigCommonConfig setMaxBigIntValue(String value) {
        return this.setMaxBigIntValue(new BigInteger(value));
    }

    public IntegralConfigCommonConfig setMinBigIntValue(BigInteger value) {
        return this.setMinValue(BigInteger.class, value);
    }

    public IntegralConfigCommonConfig setMinBigIntValue(String value) {
        return this.setMinBigIntValue(new BigInteger(value));
    }

    public IntegralConfigCommonConfig setRuleRemarkBigInteger(RuleRemark value) {
        return this.setRuleRemark(BigInteger.class, value);
    }

    private IntegralConfigCommonConfig setMaxValue(Class<?> type, Number maxValue) {
        this.map.putIfAbsent(type, new IntegralConfig());
        this.map.get(type).setMaxValue(maxValue);
        return this;
    }

    private IntegralConfigCommonConfig setMinValue(Class<?> type, Number minValue) {
        this.map.putIfAbsent(type, new IntegralConfig());
        this.map.get(type).setMinValue(minValue);
        return this;
    }

    private IntegralConfigCommonConfig setRuleRemark(Class<?> type, RuleRemark ruleRemark) {
        this.map.putIfAbsent(type, new IntegralConfig());
        this.map.get(type).setRuleRemark(ruleRemark);
        return this;
    }

    public IntegralConfigCommonConfig setMaxValue(Class<?> type, Class<?> secondType, Number maxIntValue) {
        if (!this.map.containsKey(type)) {
            IntegralConfig configDto = new IntegralConfig();
            this.map.putIfAbsent(type, configDto);
            this.map.putIfAbsent(secondType, configDto);
        }
        this.map.get(type).setMaxValue(maxIntValue);
        return this;
    }

    public IntegralConfigCommonConfig setMinValue(Class<?> type, Class<?> secondType, Number minIntValue) {
        if (!this.map.containsKey(type)) {
            IntegralConfig configDto = new IntegralConfig();
            this.map.putIfAbsent(type, configDto);
            this.map.putIfAbsent(secondType, configDto);
        }
        this.map.get(type).setMinValue(minIntValue);
        return this;
    }

    public IntegralConfigCommonConfig setRuleRemark(Class<?> type, Class<?> secondType, RuleRemark ruleRemark) {
        if (!this.map.containsKey(type)) {
            IntegralConfig configDto = new IntegralConfig();
            this.map.putIfAbsent(type, configDto);
            this.map.putIfAbsent(secondType, configDto);
        }
        this.map.get(type).setRuleRemark(ruleRemark);
        return this;
    }

    IntegralConfig getConfigOrNull(Class<? extends Number> generateType) {
        return this.map.get(generateType);
    }

    @Override
    @Deprecated
    public void merge(ConfigDto configDto) {
        throw new NotImplementedException("Not supposed to be in use.");
    }

    @Override
    public RuleRemark getRuleRemark() {
        return this.ruleRemark;
    }

    @Override
    public IntegralConfigCommonConfig setRuleRemark(RuleRemark ruleRemark) {
        this.ruleRemark = ruleRemark;
        return this;
    }
}

