/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator.config.dto;

import java.util.Map;
import java.util.function.Supplier;
import org.laoruga.dtogenerator.api.RuleRemark;
import org.laoruga.dtogenerator.api.generators.Generator;
import org.laoruga.dtogenerator.api.rules.MapRule;
import org.laoruga.dtogenerator.generator.config.dto.ConfigDto;
import org.laoruga.dtogenerator.util.ReflectionUtils;
import org.laoruga.dtogenerator.util.dummy.DummyMapClass;

public class MapConfig
implements ConfigDto {
    private Integer minSize;
    private Integer maxSize;
    private Supplier<Map<Object, Object>> mapInstanceSupplier;
    private Generator<Object> keyGenerator;
    private Generator<Object> valueGenerator;
    private RuleRemark ruleRemark;

    public MapConfig(MapRule rule) {
        this.minSize = rule.minSize();
        this.maxSize = rule.maxSize();
        this.mapInstanceSupplier = rule.mapClass() != DummyMapClass.class ? () -> ReflectionUtils.createInstance(rule.mapClass(), new Object[0]) : null;
        this.ruleRemark = rule.boundary();
    }

    public void merge(MapConfig from) {
        if (from.getMinSize() != null) {
            this.minSize = from.getMinSize();
        }
        if (from.getMaxSize() != null) {
            this.maxSize = from.getMaxSize();
        }
        if (from.getMapInstanceSupplier() != null) {
            this.mapInstanceSupplier = from.getMapInstanceSupplier();
        }
        if (from.getKeyGenerator() != null) {
            this.keyGenerator = from.getKeyGenerator();
        }
        if (from.getValueGenerator() != null) {
            this.valueGenerator = from.getValueGenerator();
        }
        if (from.getRuleRemark() != null) {
            this.ruleRemark = from.getRuleRemark();
        }
    }

    @Override
    public void merge(ConfigDto configDto) {
        MapConfig fromConfig = (MapConfig)configDto;
        if (fromConfig.getMinSize() != null) {
            this.minSize = fromConfig.getMinSize();
        }
        if (fromConfig.getMaxSize() != null) {
            this.maxSize = fromConfig.getMaxSize();
        }
        if (fromConfig.getMapInstanceSupplier() != null) {
            this.mapInstanceSupplier = fromConfig.getMapInstanceSupplier();
        }
        if (fromConfig.getKeyGenerator() != null) {
            this.keyGenerator = fromConfig.getKeyGenerator();
        }
        if (fromConfig.getValueGenerator() != null) {
            this.valueGenerator = fromConfig.getValueGenerator();
        }
        if (fromConfig.getRuleRemark() != null) {
            this.ruleRemark = fromConfig.getRuleRemark();
        }
    }

    public static MapConfigBuilder builder() {
        return new MapConfigBuilder();
    }

    public Integer getMinSize() {
        return this.minSize;
    }

    public Integer getMaxSize() {
        return this.maxSize;
    }

    public Supplier<Map<Object, Object>> getMapInstanceSupplier() {
        return this.mapInstanceSupplier;
    }

    public Generator<Object> getKeyGenerator() {
        return this.keyGenerator;
    }

    public Generator<Object> getValueGenerator() {
        return this.valueGenerator;
    }

    @Override
    public RuleRemark getRuleRemark() {
        return this.ruleRemark;
    }

    public MapConfig setMinSize(Integer minSize) {
        this.minSize = minSize;
        return this;
    }

    public MapConfig setMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public MapConfig setMapInstanceSupplier(Supplier<Map<Object, Object>> mapInstanceSupplier) {
        this.mapInstanceSupplier = mapInstanceSupplier;
        return this;
    }

    public MapConfig setKeyGenerator(Generator<Object> keyGenerator) {
        this.keyGenerator = keyGenerator;
        return this;
    }

    public MapConfig setValueGenerator(Generator<Object> valueGenerator) {
        this.valueGenerator = valueGenerator;
        return this;
    }

    @Override
    public MapConfig setRuleRemark(RuleRemark ruleRemark) {
        this.ruleRemark = ruleRemark;
        return this;
    }

    public MapConfig() {
    }

    public MapConfig(Integer minSize, Integer maxSize, Supplier<Map<Object, Object>> mapInstanceSupplier, Generator<Object> keyGenerator, Generator<Object> valueGenerator, RuleRemark ruleRemark) {
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.mapInstanceSupplier = mapInstanceSupplier;
        this.keyGenerator = keyGenerator;
        this.valueGenerator = valueGenerator;
        this.ruleRemark = ruleRemark;
    }

    public static class MapConfigBuilder {
        private Integer minSize;
        private Integer maxSize;
        private Supplier<Map<Object, Object>> mapInstanceSupplier;
        private Generator<Object> keyGenerator;
        private Generator<Object> valueGenerator;
        private RuleRemark ruleRemark;

        MapConfigBuilder() {
        }

        public MapConfigBuilder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public MapConfigBuilder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public MapConfigBuilder mapInstanceSupplier(Supplier<Map<Object, Object>> mapInstanceSupplier) {
            this.mapInstanceSupplier = mapInstanceSupplier;
            return this;
        }

        public MapConfigBuilder keyGenerator(Generator<Object> keyGenerator) {
            this.keyGenerator = keyGenerator;
            return this;
        }

        public MapConfigBuilder valueGenerator(Generator<Object> valueGenerator) {
            this.valueGenerator = valueGenerator;
            return this;
        }

        public MapConfigBuilder ruleRemark(RuleRemark ruleRemark) {
            this.ruleRemark = ruleRemark;
            return this;
        }

        public MapConfig build() {
            return new MapConfig(this.minSize, this.maxSize, this.mapInstanceSupplier, this.keyGenerator, this.valueGenerator, this.ruleRemark);
        }

        public String toString() {
            return "MapConfig.MapConfigBuilder(minSize=" + this.minSize + ", maxSize=" + this.maxSize + ", mapInstanceSupplier=" + this.mapInstanceSupplier + ", keyGenerator=" + this.keyGenerator + ", valueGenerator=" + this.valueGenerator + ", ruleRemark=" + this.ruleRemark + ")";
        }
    }
}

