/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator.config.dto;

import java.util.Arrays;
import org.laoruga.dtogenerator.api.RuleRemark;
import org.laoruga.dtogenerator.api.rules.StringRule;
import org.laoruga.dtogenerator.generator.config.dto.ConfigDto;

public class StringConfig
implements ConfigDto {
    private Integer maxLength;
    private Integer minLength;
    private String[] words;
    private String chars;
    private RuleRemark ruleRemark;
    private String regexp;

    public StringConfig(StringRule stringRule) {
        this.maxLength = stringRule.maxLength();
        this.minLength = stringRule.minLength();
        this.words = stringRule.words();
        this.chars = stringRule.chars();
        this.ruleRemark = stringRule.boundary();
        this.regexp = stringRule.regexp();
    }

    @Override
    public void merge(ConfigDto from) {
        StringConfig configDto = (StringConfig)from;
        if (configDto.getMaxLength() != null) {
            this.maxLength = configDto.getMaxLength();
        }
        if (configDto.getMinLength() != null) {
            this.minLength = configDto.getMinLength();
        }
        if (configDto.getWords() != null) {
            this.words = configDto.getWords();
        }
        if (configDto.getChars() != null) {
            this.chars = configDto.getChars();
        }
        if (configDto.getRuleRemark() != null) {
            this.ruleRemark = configDto.getRuleRemark();
        }
        if (configDto.getRegexp() != null) {
            this.regexp = configDto.getRegexp();
        }
    }

    public static StringConfigBuilder builder() {
        return new StringConfigBuilder();
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public String[] getWords() {
        return this.words;
    }

    public String getChars() {
        return this.chars;
    }

    @Override
    public RuleRemark getRuleRemark() {
        return this.ruleRemark;
    }

    public String getRegexp() {
        return this.regexp;
    }

    public StringConfig setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public StringConfig setMinLength(Integer minLength) {
        this.minLength = minLength;
        return this;
    }

    public StringConfig setWords(String[] words) {
        this.words = words;
        return this;
    }

    public StringConfig setChars(String chars) {
        this.chars = chars;
        return this;
    }

    @Override
    public StringConfig setRuleRemark(RuleRemark ruleRemark) {
        this.ruleRemark = ruleRemark;
        return this;
    }

    public StringConfig setRegexp(String regexp) {
        this.regexp = regexp;
        return this;
    }

    public StringConfig() {
    }

    public StringConfig(Integer maxLength, Integer minLength, String[] words, String chars, RuleRemark ruleRemark, String regexp) {
        this.maxLength = maxLength;
        this.minLength = minLength;
        this.words = words;
        this.chars = chars;
        this.ruleRemark = ruleRemark;
        this.regexp = regexp;
    }

    public static class StringConfigBuilder {
        private Integer maxLength;
        private Integer minLength;
        private String[] words;
        private String chars;
        private RuleRemark ruleRemark;
        private String regexp;

        public StringConfigBuilder words(String ... words) {
            this.words = words;
            return this;
        }

        StringConfigBuilder() {
        }

        public StringConfigBuilder maxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public StringConfigBuilder minLength(Integer minLength) {
            this.minLength = minLength;
            return this;
        }

        public StringConfigBuilder chars(String chars) {
            this.chars = chars;
            return this;
        }

        public StringConfigBuilder ruleRemark(RuleRemark ruleRemark) {
            this.ruleRemark = ruleRemark;
            return this;
        }

        public StringConfigBuilder regexp(String regexp) {
            this.regexp = regexp;
            return this;
        }

        public StringConfig build() {
            return new StringConfig(this.maxLength, this.minLength, this.words, this.chars, this.ruleRemark, this.regexp);
        }

        public String toString() {
            return "StringConfig.StringConfigBuilder(maxLength=" + this.maxLength + ", minLength=" + this.minLength + ", words=" + Arrays.deepToString(this.words) + ", chars=" + this.chars + ", ruleRemark=" + this.ruleRemark + ", regexp=" + this.regexp + ")";
        }
    }
}

