/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator.config.dto.datetime;

import java.time.temporal.Temporal;
import java.time.temporal.TemporalField;
import org.laoruga.dtogenerator.api.RuleRemark;
import org.laoruga.dtogenerator.constants.Boundary;
import org.laoruga.dtogenerator.generator.config.dto.datetime.ChronoConfig;

public class ChronoFieldConfig
implements ChronoConfig {
    private final long value;
    private final long leftBound;
    private final long rightBound;
    private final TemporalField field;

    ChronoFieldConfig(long value, long leftBound, long rightBound, TemporalField field) {
        this.value = value;
        this.leftBound = leftBound;
        this.rightBound = rightBound;
        this.field = field;
    }

    public static ChronoFieldConfig newAbsolute(long value, TemporalField unit) {
        return new ChronoFieldConfig(value, 0L, 0L, unit);
    }

    public static ChronoFieldConfig newBounds(long leftBound, long rightBound, TemporalField unit) {
        return new ChronoFieldConfig(0L, leftBound, rightBound, unit);
    }

    @Override
    public Temporal adjust(Temporal temporal, RuleRemark ruleRemark) {
        if (this.value != 0L) {
            return temporal.with(this.field, this.value);
        }
        long shiftValue = this.selectShift((Boundary)ruleRemark, this.leftBound, this.rightBound);
        return temporal.with(this.field, shiftValue);
    }
}

