/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator.config.dto.datetime;

import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import org.laoruga.dtogenerator.api.RuleRemark;
import org.laoruga.dtogenerator.constants.Boundary;
import org.laoruga.dtogenerator.generator.config.dto.datetime.ChronoConfig;

public class ChronoUnitConfig
implements ChronoConfig {
    private final long shift;
    private final long leftBound;
    private final long rightBound;
    private final TemporalUnit unit;

    ChronoUnitConfig(long shift, long leftBound, long rightBound, TemporalUnit unit) {
        this.shift = shift;
        this.leftBound = leftBound;
        this.rightBound = rightBound;
        this.unit = unit;
    }

    public static ChronoUnitConfig newAbsolute(long shift, TemporalUnit unit) {
        return new ChronoUnitConfig(shift, 0L, 0L, unit);
    }

    public static ChronoUnitConfig newBounds(long leftBound, long rightBound, TemporalUnit unit) {
        return new ChronoUnitConfig(0L, leftBound, rightBound, unit);
    }

    @Override
    public Temporal adjust(Temporal temporal, RuleRemark ruleRemark) {
        if (this.shift != 0L) {
            return temporal.plus(this.shift, this.unit);
        }
        long shiftValue = this.selectShift((Boundary)ruleRemark, this.leftBound, this.rightBound);
        return temporal.plus(shiftValue, this.unit);
    }
}

