/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator.config.dto.datetime;

import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.laoruga.dtogenerator.api.RuleRemark;
import org.laoruga.dtogenerator.api.rules.datetime.ChronoFieldShift;
import org.laoruga.dtogenerator.api.rules.datetime.ChronoUnitShift;
import org.laoruga.dtogenerator.api.rules.datetime.DateTimeRule;
import org.laoruga.dtogenerator.generator.config.dto.ConfigDto;
import org.laoruga.dtogenerator.generator.config.dto.datetime.ChronoConfig;
import org.laoruga.dtogenerator.generator.config.dto.datetime.ChronoFieldConfig;
import org.laoruga.dtogenerator.generator.config.dto.datetime.ChronoUnitConfig;

public class DateTimeConfig
implements ConfigDto {
    private List<ChronoConfig> chronoUnitConfigList;
    private RuleRemark ruleRemark;
    private Class<? extends Temporal> generatedType;

    public DateTimeConfig(DateTimeRule rule) {
        this(rule, null);
    }

    public DateTimeConfig(DateTimeRule rule, Class<? extends Temporal> fieldType) {
        ChronoFieldShift[] chronoFieldShifts;
        ChronoUnitShift[] chronoUnitShifts = rule.chronoUnitShift();
        if (chronoUnitShifts.length > 0) {
            this.chronoUnitConfigList = new LinkedList<ChronoConfig>();
            Arrays.stream(chronoUnitShifts).forEach(it -> this.chronoUnitConfigList.add(new ChronoUnitConfig(it.shift(), it.leftBound(), it.rightBound(), it.unit())));
        }
        if ((chronoFieldShifts = rule.chronoFieldShift()).length > 0) {
            this.chronoUnitConfigList = this.chronoUnitConfigList == null ? new LinkedList() : this.chronoUnitConfigList;
            Arrays.stream(chronoFieldShifts).forEach(it -> this.chronoUnitConfigList.add(new ChronoFieldConfig(it.shift(), it.leftBound(), it.rightBound(), it.unit())));
        }
        this.generatedType = fieldType;
        this.ruleRemark = rule.boundary();
    }

    public DateTimeConfig addChronoConfig(ChronoUnitConfig config) {
        this.chronoUnitConfigList = this.chronoUnitConfigList == null ? new LinkedList() : this.chronoUnitConfigList;
        this.chronoUnitConfigList.add(config);
        return this;
    }

    public DateTimeConfig addChronoConfig(ChronoFieldConfig config) {
        this.chronoUnitConfigList = this.chronoUnitConfigList == null ? new LinkedList() : this.chronoUnitConfigList;
        this.chronoUnitConfigList.add(config);
        return this;
    }

    @Override
    public void merge(ConfigDto from) {
        DateTimeConfig configDto = (DateTimeConfig)from;
        if (configDto.getChronoUnitConfigList() != null) {
            this.chronoUnitConfigList = configDto.getChronoUnitConfigList();
        }
        if (configDto.getChronoUnitConfigList() != null) {
            this.chronoUnitConfigList = configDto.getChronoUnitConfigList();
        }
        if (configDto.getChronoUnitConfigList() != null) {
            this.chronoUnitConfigList = configDto.getChronoUnitConfigList();
        }
        if (configDto.getRuleRemark() != null) {
            this.ruleRemark = configDto.getRuleRemark();
        }
    }

    public static DateTimeConfigBuilder builder() {
        return new DateTimeConfigBuilder();
    }

    public List<ChronoConfig> getChronoUnitConfigList() {
        return this.chronoUnitConfigList;
    }

    @Override
    public RuleRemark getRuleRemark() {
        return this.ruleRemark;
    }

    public Class<? extends Temporal> getGeneratedType() {
        return this.generatedType;
    }

    public DateTimeConfig setChronoUnitConfigList(List<ChronoConfig> chronoUnitConfigList) {
        this.chronoUnitConfigList = chronoUnitConfigList;
        return this;
    }

    @Override
    public DateTimeConfig setRuleRemark(RuleRemark ruleRemark) {
        this.ruleRemark = ruleRemark;
        return this;
    }

    public DateTimeConfig setGeneratedType(Class<? extends Temporal> generatedType) {
        this.generatedType = generatedType;
        return this;
    }

    public DateTimeConfig() {
    }

    public DateTimeConfig(List<ChronoConfig> chronoUnitConfigList, RuleRemark ruleRemark, Class<? extends Temporal> generatedType) {
        this.chronoUnitConfigList = chronoUnitConfigList;
        this.ruleRemark = ruleRemark;
        this.generatedType = generatedType;
    }

    public static class DateTimeConfigBuilder {
        private RuleRemark ruleRemark;
        private Class<? extends Temporal> generatedType;
        private List<ChronoConfig> chronoUnitConfigList;

        public DateTimeConfigBuilder addChronoConfig(ChronoUnitConfig config) {
            this.chronoUnitConfigList = this.chronoUnitConfigList == null ? new LinkedList() : this.chronoUnitConfigList;
            this.chronoUnitConfigList.add(config);
            return this;
        }

        public DateTimeConfigBuilder addChronoConfig(ChronoFieldConfig config) {
            this.chronoUnitConfigList = this.chronoUnitConfigList == null ? new LinkedList() : this.chronoUnitConfigList;
            this.chronoUnitConfigList.add(config);
            return this;
        }

        DateTimeConfigBuilder() {
        }

        public DateTimeConfigBuilder chronoUnitConfigList(List<ChronoConfig> chronoUnitConfigList) {
            this.chronoUnitConfigList = chronoUnitConfigList;
            return this;
        }

        public DateTimeConfigBuilder ruleRemark(RuleRemark ruleRemark) {
            this.ruleRemark = ruleRemark;
            return this;
        }

        public DateTimeConfigBuilder generatedType(Class<? extends Temporal> generatedType) {
            this.generatedType = generatedType;
            return this;
        }

        public DateTimeConfig build() {
            return new DateTimeConfig(this.chronoUnitConfigList, this.ruleRemark, this.generatedType);
        }

        public String toString() {
            return "DateTimeConfig.DateTimeConfigBuilder(chronoUnitConfigList=" + this.chronoUnitConfigList + ", ruleRemark=" + this.ruleRemark + ", generatedType=" + this.generatedType + ")";
        }
    }
}

