/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator.executors;

import java.lang.reflect.Field;
import java.util.function.Supplier;
import org.laoruga.dtogenerator.api.generators.Generator;

abstract class AbstractExecutor {
    private final AbstractExecutor nextExecutor;
    private static final AbstractExecutor DUMMY = new AbstractExecutor(){

        @Override
        public boolean execute(Field field, Generator<?> generator, Supplier<?> dtoInstanceSupplier) {
            throw new IllegalStateException("Next executor haven't defined");
        }
    };

    public AbstractExecutor(AbstractExecutor nextExecutor) {
        this.nextExecutor = nextExecutor;
    }

    public AbstractExecutor() {
        this.nextExecutor = DUMMY;
    }

    public abstract boolean execute(Field var1, Generator<?> var2, Supplier<?> var3);

    protected boolean executeNextInstead(Field field, Generator<?> generator, Supplier<?> dtoInstanceSupplier) {
        return this.nextExecutor.execute(field, generator, dtoInstanceSupplier);
    }

    protected AbstractExecutor getNextExecutor() {
        return this.nextExecutor;
    }
}

