/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator.executors;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.laoruga.dtogenerator.ErrorsHolder;
import org.laoruga.dtogenerator.FieldGenerators;
import org.laoruga.dtogenerator.api.generators.Generator;
import org.laoruga.dtogenerator.config.dto.DtoGeneratorStaticConfig;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.generator.executors.AbstractExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchExecutor {
    private static final Logger log = LoggerFactory.getLogger(BatchExecutor.class);
    private final FieldGenerators fieldGenerators;
    private final ThreadLocal<FieldGenerators> generatorsNotExecutedDueToError;
    private final AbstractExecutor executorsChain;
    private final ErrorsHolder errorsHolder;
    private int maxAttempts;

    public BatchExecutor(AbstractExecutor executorsChain, FieldGenerators fieldGenerators) {
        this.fieldGenerators = fieldGenerators;
        this.generatorsNotExecutedDueToError = new ThreadLocal();
        this.executorsChain = executorsChain;
        this.errorsHolder = new ErrorsHolder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        try {
            this.maxAttempts = DtoGeneratorStaticConfig.getInstance().getDtoGeneratorConfig().getMaxFailuresNumberDuringDtoGeneration();
            boolean success = this.fieldGenerators.isEmpty();
            AtomicInteger attempt = new AtomicInteger(1);
            while (!success && this.maxAttempts > attempt.get()) {
                FieldGenerators failedGenerators = this.generatorsNotExecutedDueToError.get();
                if (failedGenerators == null || failedGenerators.isEmpty()) {
                    success = this.executeEachGenerator(attempt);
                    continue;
                }
                success = this.executeEachRemainingGenerator(attempt);
            }
            if (!success) {
                this.logErrorInfo();
                throw new DtoGeneratorException("All attempts to generate field values have been exhausted, but not all fields have been set. See details for every not set field above.");
            }
        }
        finally {
            this.generatorsNotExecutedDueToError.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeEachGenerator(AtomicInteger attempt) {
        boolean allGeneratorExecutedSuccessfully = true;
        if (this.fieldGenerators.isNestedFieldsExist()) {
            this.executeNestedDtoGenerators();
        }
        Iterator<Map.Entry<Supplier<?>, FieldGenerators.GeneratorEntry>> filedGeneratorsIterator = this.fieldGenerators.getFieldGeneratorsMap().entrySet().iterator();
        while (filedGeneratorsIterator.hasNext() && this.maxAttempts >= attempt.get()) {
            Map.Entry<Supplier<?>, FieldGenerators.GeneratorEntry> nextGenerator = filedGeneratorsIterator.next();
            Iterator<Map.Entry<Field, Generator<?>>> fieldGeneratorsIterator = nextGenerator.getValue().getFieldGeneratorMap().entrySet().iterator();
            Supplier<?> dtoInstanceSupplier = nextGenerator.getKey();
            while (fieldGeneratorsIterator.hasNext() && this.maxAttempts >= attempt.get()) {
                boolean generatorExecutedSuccessfully = false;
                Map.Entry<Field, Generator<?>> next = fieldGeneratorsIterator.next();
                Field field = next.getKey();
                Generator<?> generator = next.getValue();
                try {
                    generatorExecutedSuccessfully = this.executorsChain.execute(field, generator, dtoInstanceSupplier);
                }
                catch (Exception e) {
                    this.errorsHolder.put(field, e);
                }
                finally {
                    if (generatorExecutedSuccessfully) continue;
                    allGeneratorExecutedSuccessfully = false;
                    attempt.incrementAndGet();
                    this.addGeneratorToReExecution(field, generator, dtoInstanceSupplier);
                }
            }
        }
        return allGeneratorExecutedSuccessfully;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeEachRemainingGenerator(AtomicInteger attempt) {
        FieldGenerators failedGenerators = this.generatorsNotExecutedDueToError.get();
        Iterator<Map.Entry<Supplier<?>, FieldGenerators.GeneratorEntry>> generatorsIterator = failedGenerators.getFieldGeneratorsMap().entrySet().iterator();
        while (generatorsIterator.hasNext() && this.maxAttempts >= attempt.get()) {
            Map.Entry<Supplier<?>, FieldGenerators.GeneratorEntry> nextGenerator = generatorsIterator.next();
            Iterator<Map.Entry<Field, Generator<?>>> fieldGeneratorsIterator = nextGenerator.getValue().getFieldGeneratorMap().entrySet().iterator();
            Supplier<?> dtoInstanceSupplier = nextGenerator.getKey();
            boolean layerGeneratorsExecutedSuccessfully = true;
            while (fieldGeneratorsIterator.hasNext() && this.maxAttempts >= attempt.get()) {
                boolean generatorExecutedSuccessfully = false;
                Map.Entry<Field, Generator<?>> next = fieldGeneratorsIterator.next();
                Field field = next.getKey();
                Generator<?> generator = next.getValue();
                try {
                    generatorExecutedSuccessfully = this.executorsChain.execute(field, generator, dtoInstanceSupplier);
                }
                catch (Exception e) {
                    this.errorsHolder.put(field, e);
                }
                finally {
                    layerGeneratorsExecutedSuccessfully &= generatorExecutedSuccessfully;
                    if (generatorExecutedSuccessfully) {
                        fieldGeneratorsIterator.remove();
                        continue;
                    }
                    attempt.incrementAndGet();
                }
            }
            if (!layerGeneratorsExecutedSuccessfully) continue;
            generatorsIterator.remove();
        }
        return failedGenerators.isEmpty();
    }

    private void executeNestedDtoGenerators() {
        try {
            for (FieldGenerators.NestedGeneratorEntry nestedEntry : this.fieldGenerators.getNestedDtoGenerators()) {
                this.executorsChain.execute(nestedEntry.getField(), nestedEntry.getNestedDtoGenerator(), nestedEntry.getDtoInstanceSupplier());
            }
        }
        catch (Exception e) {
            throw new DtoGeneratorException("Unexpected error during creating instances of nested DTO.", e);
        }
    }

    private void addGeneratorToReExecution(Field field, Generator<?> generator, Supplier<?> dtoInstanceSupplier) {
        FieldGenerators generatorsToReExecution = this.generatorsNotExecutedDueToError.get();
        if (generatorsToReExecution == null) {
            generatorsToReExecution = new FieldGenerators();
            this.generatorsNotExecutedDueToError.set(generatorsToReExecution);
        }
        generatorsToReExecution.addGenerator(field, generator, dtoInstanceSupplier);
    }

    private void logErrorInfo() {
        log.error("Unsuccessful generation. {} error(s) while generators execution. See problems below:\n{}", (Object)this.errorsHolder.getErrorsNumber(), (Object)this.errorsHolder);
        FieldGenerators fieldIGeneratorMap = this.generatorsNotExecutedDueToError.get();
        log.error("Unexpected state. There {} unused generator(s) left:\n{}", (Object)fieldIGeneratorMap.size(), (Object)fieldIGeneratorMap);
    }
}

