/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator.executors;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.function.Supplier;
import org.laoruga.dtogenerator.api.generators.Generator;
import org.laoruga.dtogenerator.api.generators.custom.CustomGeneratorDtoDependent;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.generator.ArrayGenerator;
import org.laoruga.dtogenerator.generator.CollectionGenerator;
import org.laoruga.dtogenerator.generator.CustomGeneratorWrapper;
import org.laoruga.dtogenerator.generator.MapGenerator;
import org.laoruga.dtogenerator.generator.executors.AbstractExecutor;
import org.laoruga.dtogenerator.generator.executors.ExecutorOfGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorOfDtoDependentGenerator
extends ExecutorOfGenerator {
    private static final Logger log = LoggerFactory.getLogger(ExecutorOfDtoDependentGenerator.class);
    private static final CustomGeneratorDtoDependent<?, ?>[] EMPTY_ARRAY = new CustomGeneratorDtoDependent[0];

    public ExecutorOfDtoDependentGenerator(AbstractExecutor nextGenerator) {
        super(nextGenerator);
    }

    @Override
    public boolean execute(Field field, Generator<?> generator, Supplier<?> dtoInstanceSupplier) {
        if (this.isItDtoDependentGenerator(generator)) {
            if (this.isDtoReadyForFieldGeneration(generator)) {
                return super.execute(field, generator, dtoInstanceSupplier);
            }
            return false;
        }
        return this.executeNextInstead(field, generator, dtoInstanceSupplier);
    }

    boolean isDtoReadyForFieldGeneration(Generator<?> generator) throws DtoGeneratorException {
        CustomGeneratorDtoDependent<?, ?>[] dtoDependentGenerators = this.getDtoDependentGeneratorsOrNull(generator);
        boolean dtoReady = Arrays.stream(dtoDependentGenerators).allMatch(CustomGeneratorDtoDependent::isDtoReady);
        log.info("Object " + (dtoReady ? "is" : "isn't") + " ready to generate dependent field value");
        return dtoReady;
    }

    CustomGeneratorDtoDependent<?, ?>[] getDtoDependentGeneratorsOrNull(Generator<?> generator) {
        if (generator instanceof CustomGeneratorDtoDependent) {
            return new CustomGeneratorDtoDependent[]{(CustomGeneratorDtoDependent)generator};
        }
        if (generator instanceof ArrayGenerator) {
            return this.getDtoDependentGeneratorsOrNull(((ArrayGenerator)generator).getElementGenerator());
        }
        if (generator instanceof CollectionGenerator) {
            return this.getDtoDependentGeneratorsOrNull(((CollectionGenerator)generator).getElementGenerator());
        }
        if (generator instanceof MapGenerator) {
            CustomGeneratorDtoDependent<?, ?>[] keyGenerator = this.getDtoDependentGeneratorsOrNull(((MapGenerator)generator).getKeyGenerator());
            CustomGeneratorDtoDependent<?, ?>[] valueGenerator = this.getDtoDependentGeneratorsOrNull(((MapGenerator)generator).getValueGenerator());
            if (keyGenerator == EMPTY_ARRAY && valueGenerator == EMPTY_ARRAY) {
                return EMPTY_ARRAY;
            }
            if (keyGenerator == EMPTY_ARRAY) {
                return valueGenerator;
            }
            if (valueGenerator == EMPTY_ARRAY) {
                return keyGenerator;
            }
            CustomGeneratorDtoDependent[] result = new CustomGeneratorDtoDependent[keyGenerator.length + valueGenerator.length];
            System.arraycopy(keyGenerator, 0, result, 0, keyGenerator.length);
            System.arraycopy(keyGenerator, 0, result, keyGenerator.length, valueGenerator.length);
            return result;
        }
        if (generator instanceof CustomGeneratorWrapper) {
            return this.getDtoDependentGeneratorsOrNull(((CustomGeneratorWrapper)generator).getUsersGeneratorInstance());
        }
        return EMPTY_ARRAY;
    }

    boolean isItDtoDependentGenerator(Generator<?> generator) {
        return this.getDtoDependentGeneratorsOrNull(generator) != EMPTY_ARRAY;
    }
}

