/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator.executors;

import java.lang.reflect.Field;
import java.util.function.Supplier;
import org.laoruga.dtogenerator.api.generators.Generator;
import org.laoruga.dtogenerator.exceptions.DtoGeneratorException;
import org.laoruga.dtogenerator.generator.executors.AbstractExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorOfGenerator
extends AbstractExecutor {
    private static final Logger log = LoggerFactory.getLogger(ExecutorOfGenerator.class);

    public ExecutorOfGenerator() {
    }

    public ExecutorOfGenerator(AbstractExecutor nextExecutor) {
        super(nextExecutor);
    }

    @Override
    public boolean execute(Field field, Generator<?> generator, Supplier<?> dtoInstanceSupplier) {
        Object result;
        try {
            result = generator.generate();
        }
        catch (Exception e) {
            throw new DtoGeneratorException("Error while generating value for the field: " + field, e);
        }
        try {
            field.setAccessible(true);
            field.set(dtoInstanceSupplier.get(), result);
        }
        catch (Exception e) {
            throw new DtoGeneratorException("Unable to set generated value of type: '" + (result != null ? result.getClass() : null) + "' to the field: '" + field.getName() + "'. field type: '" + field.getType() + "'", e);
        }
        return true;
    }
}

