/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator.providers;

import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.Function;
import org.laoruga.dtogenerator.api.generators.Generator;
import org.laoruga.dtogenerator.generator.config.GeneratorConfiguratorForList;
import org.laoruga.dtogenerator.generator.config.dto.ConfigDto;
import org.laoruga.dtogenerator.generator.providers.GeneratorsProviderByAnnotation;
import org.laoruga.dtogenerator.generator.providers.suppliers.UserGeneratorSuppliers;
import org.laoruga.dtogenerator.rule.RuleInfoList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorsProviderByAnnotationForList {
    private static final Logger log = LoggerFactory.getLogger(GeneratorsProviderByAnnotationForList.class);
    protected final GeneratorConfiguratorForList generatorConfiguratorForList;
    protected final GeneratorsProviderByAnnotation generatorsProvider;
    private final UserGeneratorSuppliers userGeneratorSuppliers;

    public GeneratorsProviderByAnnotationForList(GeneratorsProviderByAnnotation generatorsProvider, GeneratorConfiguratorForList generatorConfiguratorForList, UserGeneratorSuppliers userGeneratorSuppliers) {
        this.generatorsProvider = generatorsProvider;
        this.generatorConfiguratorForList = generatorConfiguratorForList;
        this.userGeneratorSuppliers = userGeneratorSuppliers;
    }

    Generator<?> getGenerator(RuleInfoList listRuleInfo) {
        Field field = listRuleInfo.getField();
        Class<?> fieldType = field.getType();
        String fieldName = field.getName();
        Class<?> listElementType = listRuleInfo.getElementType();
        Optional<Generator<?>> maybeUserGenerator = this.userGeneratorSuppliers.getGenerator(fieldType);
        if (maybeUserGenerator.isPresent()) {
            return maybeUserGenerator.get();
        }
        Function<ConfigDto, Generator<?>> listGeneratorSupplier = this.generatorsProvider.getDefaultGeneratorSupplier(listRuleInfo.getRule(), fieldType);
        Generator<?> elementGenerator = listRuleInfo.isElementRulesExist() ? this.generatorsProvider.getGenerator(listRuleInfo.getElementRuleInfo()) : this.generatorsProvider.getGeneratorByType(field, listElementType);
        ConfigDto listGeneratorConfig = this.generatorConfiguratorForList.createGeneratorConfig(listRuleInfo, elementGenerator, fieldType, fieldName);
        return listGeneratorSupplier.apply(listGeneratorConfig);
    }

    private GeneratorConfiguratorForList getGeneratorConfiguratorForList() {
        return this.generatorConfiguratorForList;
    }

    private GeneratorsProviderByAnnotation getGeneratorsProvider() {
        return this.generatorsProvider;
    }

    private UserGeneratorSuppliers getUserGeneratorSuppliers() {
        return this.userGeneratorSuppliers;
    }
}

