/*
 * Decompiled with CFR 0.152.
 */
package org.laoruga.dtogenerator.generator.providers;

import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.Function;
import org.laoruga.dtogenerator.api.generators.Generator;
import org.laoruga.dtogenerator.generator.config.GeneratorConfiguratorForMap;
import org.laoruga.dtogenerator.generator.config.dto.ConfigDto;
import org.laoruga.dtogenerator.generator.providers.GeneratorsProviderByAnnotation;
import org.laoruga.dtogenerator.generator.providers.suppliers.UserGeneratorSuppliers;
import org.laoruga.dtogenerator.rule.RuleInfo;
import org.laoruga.dtogenerator.rule.RuleInfoMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorsProviderByAnnotationForMap {
    private static final Logger log = LoggerFactory.getLogger(GeneratorsProviderByAnnotationForMap.class);
    private final GeneratorsProviderByAnnotation generatorsProvider;
    private final GeneratorConfiguratorForMap configuratorForMap;
    private final UserGeneratorSuppliers userGeneratorSuppliers;

    public GeneratorsProviderByAnnotationForMap(GeneratorsProviderByAnnotation generatorsProvider, GeneratorConfiguratorForMap configuratorForMap, UserGeneratorSuppliers userGeneratorSuppliers) {
        this.generatorsProvider = generatorsProvider;
        this.configuratorForMap = configuratorForMap;
        this.userGeneratorSuppliers = userGeneratorSuppliers;
    }

    Generator<?> getGenerator(RuleInfoMap mapRruleInfo) {
        Field field = mapRruleInfo.getField();
        Class<?> fieldType = field.getType();
        String fieldName = field.getName();
        Optional<Generator<?>> maybeUserGenerator = this.userGeneratorSuppliers.getGenerator(fieldType);
        if (maybeUserGenerator.isPresent()) {
            return maybeUserGenerator.get();
        }
        Function<ConfigDto, Generator<?>> mapGenBuilder = this.generatorsProvider.getDefaultGeneratorSupplier(mapRruleInfo.getRule(), fieldType);
        RuleInfo keyRule = mapRruleInfo.getKeyRule();
        Generator<?> keyGenerator = mapRruleInfo.isKeyRulesExist() ? this.generatorsProvider.getGenerator(keyRule) : this.generatorsProvider.getGeneratorByType(field, keyRule.getRequiredType());
        RuleInfo valueRule = mapRruleInfo.getValueRule();
        Generator<?> valueGenerator = mapRruleInfo.isValueRulesExist() ? this.generatorsProvider.getGenerator(valueRule) : this.generatorsProvider.getGeneratorByType(field, valueRule.getRequiredType());
        ConfigDto configDto = this.configuratorForMap.createGeneratorConfig(mapRruleInfo, keyGenerator, valueGenerator, fieldType, fieldName);
        return mapGenBuilder.apply(configDto);
    }

    private GeneratorsProviderByAnnotation getGeneratorsProvider() {
        return this.generatorsProvider;
    }

    private GeneratorConfiguratorForMap getConfiguratorForMap() {
        return this.configuratorForMap;
    }

    private UserGeneratorSuppliers getUserGeneratorSuppliers() {
        return this.userGeneratorSuppliers;
    }
}

